/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.io.nio;

import java.sql.Timestamp;
import java.util.List;

import org.F11.scada.data.LoggingRowData;

/**
 * LoggingDatãXgԂ܂B
 * @author maekawa
 */
public interface LogTableSelectService {
	/**
	 * LoggingDatãXgԂ܂B
	 * @param tableName e[u
	 * @param dataHolders of[^z_[̃Xg
	 * @param limit R[h̍ől
	 * @return LoggingDatãXgԂ܂B
	 */
	List select(String tableName, List dataHolders, int limit);

	/**
	 * Ŏw肵VR[hLoggingDatãXgԂ܂B
	 * @param tableName e[u
	 * @param dataHolders of[^z_[̃Xg
	 * @param time of[^z_[̌
	 * @return Ŏw肵VR[hLoggingDatãXgԂ܂B
	 */
	List select(String tableName, List dataHolders, Timestamp time);

	/**
	 * e[u̍ŌÃR[hԂ܂B
	 * @param tableName e[u
	 * @param dataHolders of[^z_[̃Xg
	 * @return e[u̍ŌÃR[hԂ܂B
	 */
	LoggingRowData selectFirst(String tableName, List dataHolders);

	/**
	 * e[u̍ŐVR[hԂ܂B
	 * @param tableName e[u
	 * @param dataHolders of[^z_[̃Xg
	 * @return e[u̍ŐVR[hԂ܂B
	 */
	LoggingRowData selectLast(String tableName, List dataHolders);
	/**
	 * ̓̑ÕR[h𒊏oĕԂ܂
	 * @param name e[u
	 * @param dataHolders of[^z_[̃Xg
	 * @param start 
	 * @param limit ő匏
	 * @return ̓̑ÕR[h𒊏oĕԂ܂
	 */
	List selectBeforeAfter(String name, List dataHolders, Timestamp start, int limit);

	/**
	 * Ŏw肵CSṼXgԂ܂B
	 * @param tableName e[u
	 * @param dataHolders of[^z_[̃Xg
	 * @param startTime of[^z_[̌
	 * @param endTime of[^z_[̌
	 * @return Ŏw肵VR[hLoggingDatãXgԂ܂B
	 */
	List select(String tableName, List dataHolders, Timestamp startTime, Timestamp endTime);
}