/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/server/logging/LoggingTask.java,v 1.13.4.4 2006/05/26 05:51:07 frdm Exp $
 * $Revision: 1.13.4.4 $
 * $Date: 2006/05/26 05:51:07 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.logging;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;

import org.F11.scada.server.event.LoggingDataEvent;
import org.F11.scada.server.event.LoggingDataListener;
import org.F11.scada.server.io.HandlerFactory;
import org.F11.scada.server.io.ValueListHandlerElement;
import org.F11.scada.server.io.ValueListHandlerManager;
import org.apache.log4j.Logger;

/**
 * MOp̃^XNNXłB
 */
public class LoggingTask extends TimerTask {
	/** f[^z_̃Xgł */
	protected List dataHolders;
	/** MOXi[̃Xg */
	private List loggingListeners;
	/** MOf[^nh */
	private ValueListHandlerElement handler;
	/** nh[t@g[ */
	private final String factoryName;

	/** MOAPI */
	private static Logger logger;
	
	/** QƂe[u */
	private final List<String> tables;
	
	private final String schedule;

	/**
	 * RXgN^
	 * @param name MO
	 * @param dataHolders f[^z_[̃Xg
	 * @param factoryName f[^iNX
	 * @exception SQLException DBMSɐڑłȂƂ
	 */
	public LoggingTask(
			String name,
			List dataHolders,
			String factoryName,
			ValueListHandlerManager handlerManager,
			String schedule,
			List<String> tables,
			boolean isPadding)
			throws SQLException, MalformedURLException, RemoteException {
		super();
		this.dataHolders = dataHolders;
		logger = Logger.getLogger(getClass().getName());

		this.factoryName = factoryName;
		HandlerFactory factory = HandlerFactory.getHandlerFactory(factoryName);
		addLoggingListener(factory.createStoreHandler(name, isPadding));

		// PostgreSQL Value List Handler
		handler = factory.createValueListHandler(name, dataHolders);
		addLoggingListener(handler);
		handlerManager.addValueListHandlerElement(name, handler);
		this.tables = tables;
		this.schedule = schedule;
	}

	/**
	 * XPW[Jn̏B
	 */
	public void run() {
		logger.debug("data store start!!");
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.MILLISECOND, 0);
		Timestamp today = new Timestamp(cal.getTime().getTime());
		//dataHolders蕶񁨃f[^z_[Cxg΂B
		LoggingDataEvent dataEvent = new LoggingDataEvent(this, today, dataHolders);
		fireChangeLoggingData(dataEvent);
	}
	
	/**
	 * MOf[^ύXCxg̃Xi[o^܂B
	 * @param l MOf[^ύXCxg̃Xi[IuWFNg
	 */
	public synchronized void addLoggingListener(LoggingDataListener l) {
		if (loggingListeners == null) {
			loggingListeners = new LinkedList();
		}
		loggingListeners.add(l);
	}
	
	/**
	 * MOf[^ύXCxg̃Xi[폜܂B
	 * @param l MOf[^ύXCxg̃Xi[IuWFNg
	 */
	public synchronized void removeLoggingListener(LoggingDataListener l) {
		if (loggingListeners == null) {
			return;
		}
		loggingListeners.remove(l);
	}
	
	/**
	 * MOf[^ύXCxgXi[ɔ΂܂B
	 */
	protected void fireChangeLoggingData(LoggingDataEvent event) {
		if (loggingListeners == null || loggingListeners.size() <= 0) {
			return;
		}

		synchronized(this) {
			for (Iterator it = loggingListeners.iterator(); it.hasNext();) {
				LoggingDataListener element = (LoggingDataListener) it.next();
				element.changeLoggingData(event);
			}
		}
	}

	public List getDataHolders() {
		return dataHolders; 
	}
	
	/**
	 * MOf[^nhɁAXVナXi[ǉ܂B
	 * @param l
	 */
	public void addElementLoggingListener(LoggingDataListener l) {
		handler.addLoggingDataListener(l);
	}

	/**
	 * nh[t@Ng[Ԃ܂B
	 * @return nh[t@Ng[Ԃ܂B
	 */
	public String getFactoryName() {
		return factoryName;
	}
	
	/**
	 * A鑼e[ũXgԂ܂B
	 * 
	 * @return A鑼e[ũXgԂ܂B
	 */
	public List<String> getTables() {
		return Collections.unmodifiableList(tables);
	}

	/**
	 * XPW[Ԃ܂B
	 * 
	 * @return XPW[Ԃ܂B
	 */
	public String getSchedule() {
		return schedule;
	}
}
