/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.logging.report;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.F11.scada.server.event.LoggingDataEvent;
import org.F11.scada.server.event.LoggingDataListener;
import org.F11.scada.server.io.ItemUtil;
import org.F11.scada.server.io.ValueListHandler;
import org.F11.scada.server.io.postgresql.S2ContainerUtil;
import org.F11.scada.server.logging.report.schedule.CsvSchedule;
import org.F11.scada.server.logging.report.schedule.CsvScheduleFactory;
import org.F11.scada.server.register.HolderString;
import org.apache.log4j.Logger;
import org.seasar.framework.container.S2Container;

/**
 * @author maekawa
 */
public abstract class AbstractCsvoutTask implements LoggingDataListener {
	/** MOe[u */
	protected String logg_name;
	/** nh */
	protected ValueListHandler handlerManager;
	/** f[^z_̃Xg */
	protected List<HolderString> dataHolders;
	/** CSVt@C̕ۑfBNg */
	protected String currDir;
	/** CSVt@C̐擪 */
	protected String csv_head;
	/** CSVt@C̓ttH[}bg */
	protected String csv_mid;
	/** CSVt@C̖ */
	protected String csv_foot;
	/** CSVt@C̕ۑ */
	protected int keepCount;
	/** R[hwb_̕ttO */
	protected boolean data_head = true;
	/** R[htZowpNX */
	protected CsvSchedule csvSchedule;
	/** t@Co͊JnԂ̎ true = 0:0`23:59:59 false = 0:0:1`0:0:0 */
	protected boolean dataMode = true;
	/** ACef[^擾[eBeB[ */
	protected final ItemUtil util;
	/** t@CItZbg(~b) */
	protected final long midOffset;
	/** e[u */
	protected final List<String> tables;

	/** MOAPI */
	protected static Logger logger = Logger.getLogger(AbstractCsvoutTask.class);

	/**
	 * RXgN^
	 * 
	 * @param name MO
	 * @param dataHolders f[^z_[̃Xg
	 * @param midOffset
	 * @param factoryName f[^iNX
	 * @exception SQLException DBMSɐڑłȂƂ
	 */
	public AbstractCsvoutTask(
			String logg_name,
			ValueListHandler handlerManager,
			String schedule,
			List<HolderString> dataHolders,
			String currDir,
			String csv_head,
			String csv_mid,
			String csv_foot,
			int keepCount,
			long midOffset,
			List<String> tables) throws NoSuchFieldException, IllegalAccessException {
		super();

		this.logg_name = logg_name;
		this.dataHolders = dataHolders;
		this.currDir = currDir;
		this.csv_head = csv_head;
		this.csv_mid = csv_mid;
		this.csv_foot = csv_foot;
		this.keepCount = keepCount;
		this.handlerManager = handlerManager;
		this.midOffset = midOffset;
		this.tables = tables;
		CsvScheduleFactory factory = new CsvScheduleFactory();
		csvSchedule = factory.getCsvSchedule(schedule);
		S2Container container = S2ContainerUtil.getS2Container();
		util = (ItemUtil) container.getComponent("itemutil");
	}

	public void changeLoggingData(LoggingDataEvent event) {
		if (csvSchedule.isOutput()) {
			File dir = new File(currDir);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			// ꎞt@C쐬
			File tmpFile = new File(currDir + logg_name + csv_foot);
			Timestamp startTime = csvOut(tmpFile);
			if (startTime != null) {
				// t@CύX
				DateFormat fileDf = new SimpleDateFormat(csv_mid);
				File newFile = new File(currDir + csv_head
						+ fileDf.format(getMidTime(startTime)) + csv_foot);
				newFile.delete();
				tmpFile.renameTo(newFile);
			}
			// t@C폜
			FilenameFilter filter = new CsvFilter(csv_head, csv_foot);
			removeOldFile(dir.listFiles(filter), keepCount);
		}
	}

	private Timestamp getMidTime(Timestamp startTime) {
		return new Timestamp(startTime.getTime() - midOffset);
	}

	/**
	 * CSVt@C쐬
	 * 
	 * @param file 쐬CSVt@C
	 * @return 擪R[h̓t
	 */
	abstract protected Timestamp csvOut(File file);

	/**
	 * w茏cAҏWťÂɃt@C폜
	 * 
	 * @param files t@C̈ꗗ
	 * @param cnt c
	 */
	protected void removeOldFile(File[] files, int cnt) {
		if (null == files || files.length <= cnt)
			return;

		ArrayList<File> fileList = new ArrayList<File>(files.length);
		for (int i = 0; i < files.length; i++) {
			fileList.add(files[i]);
		}
		while (cnt < fileList.size()) {
			long first = System.currentTimeMillis();
			File firstFile = null;
			for (Iterator<File> it = fileList.iterator(); it.hasNext();) {
				File file = it.next();
				if (file.lastModified() < first) {
					first = file.lastModified();
					firstFile = file;
				}
			}
			firstFile.delete();
			fileList.remove(firstFile);
		}
	}

	/**
	 * 擪Ɩw肷t@CtB^[NX
	 * 
	 * @author hori
	 * 
	 */
	protected class CsvFilter implements FilenameFilter {
		private String head;
		private String foot;

		public CsvFilter(String head, String foot) {
			this.head = head;
			this.foot = foot;
		}

		public boolean accept(File dir, String name) {
			return name.startsWith(head) && name.endsWith(foot);
		}
	}
}
