/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.schedule;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

import org.F11.scada.data.WifeDataSchedule;
import org.F11.scada.server.schedule.point.dto.DuplicateSeparateScheduleDto;
import org.F11.scada.server.schedule.point.dto.ScheduleGroupDto;
import org.F11.scada.server.schedule.point.dto.SchedulePointRowDto;

public interface SchedulePointCommunicator {
	/**
	 * O[vԍz_XV܂B
	 * 
	 * @param dto sf[^
	 */
	void setHolder(SchedulePointRowDto dto);

	/**
	 * Ώۃz_̒ʐMf[^Ԃ܂B
	 * 
	 * @param dto Ώۃz_
	 * @return Ώۃz_̒ʐMf[^Ԃ܂B
	 */
	List getHolderData(List dto);

	/**
	 * }X^XPW[ʃXPW[փf[^Rs[܂B
	 * 
	 * @param src Rs[}X^XPW[
	 * @param dest Rs[ʃXPW[z_̔z
	 * @deprecated
	 */
	void duplicateSeparateSchedule(
			ScheduleGroupDto src,
			SchedulePointRowDto[] dest);

	/**
	 * }X^XPW[ʃXPW[փf[^Rs[܂B
	 * 
	 * @param dto XPW[Rs[IuWFNg
	 */
	void duplicateSeparateSchedule(DuplicateSeparateScheduleDto dto);

	/**
	 * ʃXPW[(XPW[)lԂ܂B
	 * 
	 * @param dto z_̐ݒ肳ꂽIuWFNg
	 * @return ʃXPW[(XPW[)lԂ܂B
	 */
	WifeDataSchedule getSeparateSchedule(SchedulePointRowDto dto);

	/**
	 * ʃXPW[lXV܂B
	 * 
	 * @param dto z_̐ݒ肳ꂽsf[^
	 * @param date XV
	 * @param data XVf[^l
	 * @throws RemoteException
	 */
	void updateSeperateSchedule(
			SchedulePointRowDto dto,
			Date date,
			WifeDataSchedule data);

}
