/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.theme;

import java.awt.FlowLayout;

import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.F11.scada.applet.symbol.GraphicManager;
import org.F11.scada.parser.alarm.AlarmDefine;
import org.F11.scada.parser.alarm.TitleConfig;
import org.F11.scada.xwife.applet.AbstractWifeApplet;

/**
 * LogoR|[lg𐶐t@Ng[NXłB
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class LogoFactory {
    private final AlarmDefine alarmDefine;

    /**
     * ftHg̒`t@CŃt@Ng[܂B
     */
    public LogoFactory() {
        alarmDefine = new AlarmDefine();
    }

    /**
     * Ŏw肳ꂽt@CŁAt@Ng[܂B
     * @param filePath `t@C
     */
    public LogoFactory(String filePath) {
        alarmDefine = new AlarmDefine(filePath);
    }

    /**
     * LogoR|[lg𐶐ĕԂ܂B
     * @return LogoR|[lg
     */
    public JComponent getLogo(AbstractWifeApplet applet) {
        JComponent component = new Logo(applet);
        TitleConfig config = alarmDefine.getAlarmConfig().getTitleConfig();
        if (config != null) {
            String image = config.getImage();
            if (image != null && !"".equals(image)) {
                Icon icon = GraphicManager.get(image);
                if (icon != null) {
                    component = new JPanel(new FlowLayout(FlowLayout.LEFT, 5, 0));
                    component.add(new LogoTime(applet));
                    JLabel iconLabel = new JLabel(icon);
                    iconLabel.addMouseListener(new AboutDialogListener());
                    component.add(iconLabel);
                }
            }
        }

        return component;
    }
}
