/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2008 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

package org.F11.scada.tool.conf;

import java.util.List;

import org.F11.scada.tool.conf.io.TimeSetBean;
import org.F11.scada.tool.conf.io.TimeSetTaskBean;

/**
 * TimeSet.xml̃Xg[C^[tFCXł
 * 
 * @author maekawa
 *
 */
public interface TimeSetManager {
	/**
	 * Ώۃ^XÑvpeBԂ܂
	 * 
	 * @param name Ώۃ^XN
	 * @param key vpeB
	 * @param def vpeBl
	 * @return Ώۃ^XÑvpeBԂ܂
	 */
	String getTimeSet(String name, String key, String def);

	/**
	 * Ώۃ^XN̏XgԂ܂
	 * @param name Ώۃ^XN
	 * @return Ώۃ^XN̏XgԂ܂
	 */
	List<TimeSetBean> getTimeSetBeansList(String name);

	/**
	 * Ώۃ^XÑvpeBݒ肵܂
	 * @param name Ώۃ^XN
	 * @param key vpeB
	 * @param value vpeBl 
	 */
	void setTimeSet(String name, String key, String value);

	/**
	 * Ώۃ^XNɏXgݒ肵܂
	 * 
	 * @param name Ώۃ^XN
	 * @param list Xg
	 */
	void setTimeSetBeansList(String name, List<TimeSetBean> list);

	/**
	 * ^XNݒ肵܂
	 * ^XN null ȊOȂ狌^XN܂
	 * 
	 * @param bean ^XN
	 * @param oldName ^XN
	 */
	void setTimeSetTask(TimeSetTaskBean bean, String oldName);

	/**
	 * Ώۃ^XN폜܂
	 * @param bean Ώۃ^XN
	 * @return 폜^XN
	 */
	TimeSetTaskBean removeTimeSetTask(TimeSetTaskBean bean);
	
	/**
	 * ^XÑXgԂ܂
	 * 
	 * @return ^XÑXgԂ܂
	 */
	List<TimeSetTaskBean> getTimeSetTask();
}