/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2007 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

package org.F11.scada.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class ComponentUtil {
	/** HTML̊Jn */
	public static final String HTML_START = "<html><body><p>";
	/** HTML̏I */
	public static final String HTML_END = "</p></body></html>";

	/**
	 * R|[lgɃ}EX|Cg邩肵܂B
	 * 
	 * @param rectangle R|[lgʒu
	 * @param point }EX|Cgʒu
	 * @return R|[lgɃ}EX|Cgꍇ trueAꍇ false Ԃ܂B
	 */
	public static boolean contains(Rectangle rectangle, Point point) {
		return point.x >= 0
			&& point.y >= 0
			&& rectangle.width >= point.x
			&& rectangle.height >= point.y;
	}

	/**
	 * ReȋΏۃNXqR|[lgԂ܂B
	 * 
	 * @param klass NX
	 * @param container ΏۂɂȂReiIuWFNg
	 * @return ΏۃReiIuWFNgɁANX݂ꍇ͂̃R|[lg𑶍݂Ȃꍇ null Ԃ܂B
	 */
	public static Component getChildrenComponent(
			Class<?> klass,
			Container container) {
		Component ret = null;
		Component[] components = container.getComponents();
		for (int i = 0; i < components.length; i++) {
			Component component = components[i];
			if (klass.isInstance(component)) {
				ret = component;
				break;
			}
		}
		return ret;
	}

	/**
	 * {@link SwingUtilities#getAncestorOfClass}̌^_ŁB R|[lgKw comp
	 * ̏ʂ邽߂̊ȈՃ\bhłA c NX̍ŏ̃IuWFNgԂ܂Bc NXȂꍇ null
	 * Ԃ܂B
	 * 
	 * @param <C> NX
	 * @param c NXe
	 * @param comp ΏۃR|[lg
	 * @return ʂɌΏۂ̃NX΂̃IuWFNg𖳂ꍇ null Ԃ܂
	 */
	public static <C extends Container> C getAncestorOfClass(
			Class<C> c,
			Component comp) {
		return (C) SwingUtilities.getAncestorOfClass(c, comp);
	}

	public static void addLabel(GridBagConstraints c, JPanel panel, JLabel label) {
		panel.add(label);
		c.weightx = 1.0;
		c.gridwidth = 1;
		panel.add(label, c);
	}

	public static void addTextArea(
			GridBagConstraints c,
			JPanel panel,
			JTextField text,
			String string) {
		c.weightx = 1.0;
		c.gridwidth = GridBagConstraints.REMAINDER;
		text.setText(string);
		panel.add(text, c);
	}

	/**
	 * CNX̐e̒ɃR|[lgzu܂B
	 * 
	 * @param <C> eNX
	 * @param c eNX
	 * @param comp ɔzuR|[lg
	 */
	public static <C extends Window> void setCenter(Class<C> c, Component comp) {
		Window parent = ComponentUtil.getAncestorOfClass(c, comp);
		Dimension dlgSize = comp.getSize();
		Dimension frmSize = parent.getSize();
		Point loc = parent.getLocation();
		comp.setLocation(
			(frmSize.width - dlgSize.width) / 2 + loc.x,
			(frmSize.height - dlgSize.height) / 2 + loc.y);
	}
}
