package org.F11.scada.xwife.applet.alarm;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class RowHeaderTable extends JTable {
	public RowHeaderTable(JTable dataTable, String name, int width) {
		super(new RowHeaderDataModel(dataTable));
		// B̗
		TableColumn tc = new TableColumn(0, width);

		// EwiDF̃_[o^
		DefaultTableCellRenderer r = new DefaultTableCellRenderer();
		r.setHorizontalAlignment(SwingConstants.CENTER);
		r.setBackground(dataTable.getTableHeader().getBackground());
		tc.setCellRenderer(r);

		tc.setHeaderValue(name); // 񌩏o(ږ)
		tc.setResizable(false); // TCYύX֎~
		JTableHeader h = super.getTableHeader();
		h.setReorderingAllowed(false); // ̓ւ(hbO)֎~

		addColumn(tc);
		setEnabled(false);
	}

	private static class RowHeaderDataModel extends DefaultTableModel implements
			TableModelListener {
		protected JTable dataTable;

		public RowHeaderDataModel(JTable dataTable) {
			this.dataTable = dataTable; // f[^pe[u

			TableModel dataModel = dataTable.getModel();
			dataModel.removeTableModelListener(this);
			dataModel.addTableModelListener(this);
		}

		@Override
		public Object getValueAt(int row, int column) {
			// f[^pe[u̍sԍԂ
			// RowHeaderTableg̓\[gtB^O͍sȂׁArow͕\psԍƈvĂ
			return row + 1;
		}

		@Override
		public Class<?> getColumnClass(int columnIndex) {
			return Integer.class;
		}

		@Override
		public void setValueAt(Object aValue, int row, int column) {
			// l̓o^͍sȂ
		}

		@Override
		public boolean isCellEditable(int row, int column) {
			return false; // ҏWs
		}

		@Override
		public int getRowCount() {
			if (dataTable != null) {
				return dataTable.getRowCount(); // f[^e[u̕\sԂ
			}
			return 0;
		}

		/*
		 * TableModelListener̃\bhłAf[^pTableModelɕύXƂɌĂ΂B
		 */
		public void tableChanged(TableModelEvent e) {
			switch (e.getType()) {
			case TableModelEvent.INSERT: // sǉ
			case TableModelEvent.DELETE: // s폜
				super.fireTableChanged(e);
				break;
			default:
				// System.out.println("tableChanged:" + e.getType());
				break;
			}
		}
	}
}
