package org.F11.scada.xwife.server.communicater;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.util.StringTokenizer;

import org.F11.scada.server.communicater.Environment;

/**
 * Wife̊ݒێNXłB
 * @author  maekawa
 * @version 1.0
 */
public class EnvironmentProperty implements Environment {
	/** Ǘԍ̃vpeBL[\萔ł */
	public static final String DEVICE_ID_KEY = "DEVICE_ID";
	/** ʐM@̃vpeBL[\萔ł */
	public static final String DEVICE_KIND_KEY = "DEVICE_KIND";

	/** PLC|[gio[̃vpeBL[\萔ł */
	public static final String PLC_PORT_NO_KEY = "PLC_PORT_NO";
	/** PLCR}hʂ̃vpeBL[\萔ł */
	public static final String PLC_COMM_KIND_KEY = "PLC_COMM_KIND";
	/** PLC IPAhX̃vpeBL[\萔ł */
	public static final String PLC_IP_ADDRESS_KEY = "PLC_IP_ADDRESS";
	/** PLClbgio[̃vpeBL[\萔ł */
	public static final String PLC_NET_NO_KEY = "PLC_NET_NO";
	/** PLCm[hio[̃vpeBL[\萔ł */
	public static final String PLC_NODE_NO_KEY = "PLC_NODE_NO";
	/** PLCjbgio[̃vpeBL[\萔ł */
	public static final String PLC_UNIT_NO_KEY = "PLC_UNIT_NO";
	/** PLCCPUĎԂ̃vpeBL[\萔ł */
	public static final String PLC_WATCH_WAIT_KEY = "PLC_WATCH_WAIT";
	/** PLC^CAEg̃vpeBL[\萔ł */
	public static final String PLC_TIMEOUT_KEY = "PLC_TIMEOUT";
	/** PLC^CAEggC񐔂̃vpeBL[\萔ł */
	public static final String PLC_RETRY_COUNT_KEY = "PLC_RETRY_COUNT";
	/** PLCʐM҂Ԃ̃vpeBL[\萔ł */
	public static final String PLC_RECOVERY_WAIT_KEY = "PLC_RECOVERY_WAIT";

	/** zXglbgio[̃vpeBL[\萔ł */
	public static final String HOST_NET_NO_KEY = "HOST_NET_NO";
	/** PLC|[gio[̃vpeBL[\萔ł */
	public static final String HOST_PORT_NO_KEY = "HOST_PORT_NO";
	/** zXgIPAhX̃vpeBL[\萔ł */
	public static final String HOST_IP_ADDRESS_KEY = "HOST_IP_ADDRESS";

	/** PLC IPAhX(dp)̃vpeBL[\萔ł */
	public static final String PLC_IP_ADDRESS2_KEY = "PLC_IP_ADDRESS2";
	
	/** L[ŕێ */
	private java.util.Properties environments;

	/** Creates new WifePlcConfigure */
	public EnvironmentProperty() {
		environments = new java.util.Properties();
	}

	/** vpeB deviceID ̎擾\bhB
	 * @return vpeB plcID ̒lB
	 */
	public String getDeviceID() {
		return environments.getProperty(DEVICE_ID_KEY);
	}
	/** vpeB deviceID ̐ݒ胁\bhB
	 * @param deviceID vpeB deviceID ̐VlB
	 */
	public void setDeviceID(String deviceID) {
		environments.setProperty(DEVICE_ID_KEY, deviceID);
	}

	/** vpeB deviceKind ̎擾\bhB
	 * @return vpeB deviceKind ̒lB
	 */
	public String getDeviceKind() {
		return environments.getProperty(DEVICE_KIND_KEY);
	}
	/** vpeB deviceKind ̐ݒ胁\bhB
	 * @param deviceKind vpeB deviceKind ̐VlB
	 */
	public void setDeviceKind(String deviceKind) {
		environments.setProperty(DEVICE_KIND_KEY, deviceKind);
	}

	/** vpeB plcIpAddress ̎擾\bhB
	 * @return vpeB plcIpAddress ̒lB
	 */
	public String getPlcIpAddress() {
		return environments.getProperty(PLC_IP_ADDRESS_KEY);
	}
	/** vpeB plcIpAddress ̐ݒ胁\bhB
	 * @param plcIpAddress vpeB plcIpAddress ̐VlB
	 */
	public void setPlcIpAddress(String plcIpAddress) {
		environments.setProperty(PLC_IP_ADDRESS_KEY, plcIpAddress);
	}

	/** vpeB plcPortNo ̎擾\bhB
	 * @return vpeB plcPortNo ̒lB
	 */
	public int getPlcPortNo() {
		return Integer.parseInt(environments.getProperty(PLC_PORT_NO_KEY));
	}
	/** vpeB plcPortNo ̐ݒ胁\bhB
	 * @param plcPortNo vpeB plcPortNo ̐VlB
	 */
	public void setPlcPortNo(int plcPortNo) {
		environments.setProperty(PLC_PORT_NO_KEY, String.valueOf(plcPortNo));
	}

	/** vpeB plcCommKind ̎擾\bhB
	 * @return vpeB plcCommKind ̒lB
	 */
	public String getPlcCommKind() {
		return environments.getProperty(PLC_COMM_KIND_KEY);
	}
	/** vpeB plcCommKind ̐ݒ胁\bhB
	 * @param plcCommKind vpeB plcCommKind ̐VlB
	 */
	public void setPlcCommKind(String plcCommKind) {
		environments.setProperty(PLC_COMM_KIND_KEY, plcCommKind);
	}

	/** vpeB plcNetNo ̎擾\bhB
	 * @return vpeB plcNetNo ̒lB
	 */
	public int getPlcNetNo() {
		return Integer.parseInt(environments.getProperty(PLC_NET_NO_KEY));
	}
	/** vpeB plcNetNo ̐ݒ胁\bhB
	 * @param plcNetNo vpeB plcNetNo ̐VlB
	 */
	public void setPlcNetNo(int plcNetNo) {
		environments.setProperty(PLC_NET_NO_KEY, String.valueOf(plcNetNo));
	}

	/** vpeB plcNodeNo ̎擾\bhB
	 * @return vpeB plcNodeNo ̒lB
	 */
	public int getPlcNodeNo() {
		return Integer.parseInt(environments.getProperty(PLC_NODE_NO_KEY));
	}
	/** vpeB plcNodeNo ̐ݒ胁\bhB
	 * @param plcNodeNo vpeB plcNodeNo ̐VlB
	 */
	public void setPlcNodeNo(int plcNodeNo) {
		environments.setProperty(PLC_NODE_NO_KEY, String.valueOf(plcNodeNo));
	}

	/** vpeB plcUnitNo ̎擾\bhB
	 * @return vpeB plcUnitNo ̒lB
	 */
	public int getPlcUnitNo() {
		return Integer.parseInt(environments.getProperty(PLC_UNIT_NO_KEY));
	}
	/** vpeB plcUnitNo ̐ݒ胁\bhB
	 * @param plcUnitNo vpeB plcUnitNo ̐VlB
	 */
	public void setPlcUnitNo(int plcUnitNo) {
		environments.setProperty(PLC_UNIT_NO_KEY, String.valueOf(plcUnitNo));
	}

	/** vpeB plcWatchWait ̎擾\bhB
	 * @return vpeB plcWatchWait ̒lB
	 */
	public int getPlcWatchWait() {
		return Integer.parseInt(environments.getProperty(PLC_WATCH_WAIT_KEY));
	}
	/** vpeB plcWatchWait ̐ݒ胁\bhB
	 * @param plcWatchWait vpeB plcWatchWait ̐VlB
	 */
	public void setPlcWatchWait(int plcWatchWait) {
		environments.setProperty(PLC_WATCH_WAIT_KEY, String.valueOf(plcWatchWait));
	}

	/** vpeB plcTimeout ̎擾\bhB
	 * @return vpeB plcTimeout ̒lB
	 */
	public int getPlcTimeout() {
		return Integer.parseInt(environments.getProperty(PLC_TIMEOUT_KEY));
	}
	/** vpeB plcTimeout ̐ݒ胁\bhB
	 * @param plcTimeout vpeB plcTimeout ̐VlB
	 */
	public void setPlcTimeout(int plcTimeout) {
		environments.setProperty(PLC_TIMEOUT_KEY, String.valueOf(plcTimeout));
	}

	/** vpeB plcRetryTime ̎擾\bhB
	 * @return vpeB plcRetryTime ̒lB
	 */
	public int getPlcRetryCount() {
		return Integer.parseInt(environments.getProperty(PLC_RETRY_COUNT_KEY));
	}
	/** vpeB retry ̐ݒ胁\bhB
	 * @param plcRetryTime vpeB retry ̐VlB
	 */
	public void setPlcRetryCount(int plcRetryCount) {
		environments.setProperty(PLC_RETRY_COUNT_KEY, String.valueOf(plcRetryCount));
	}

	/** vpeB plcRecoveryWait ̎擾\bhB
	 * @return vpeB plcRecoveryWait ̒lB
	 */
	public int getPlcRecoveryWait() {
		return Integer.parseInt(environments.getProperty(PLC_RECOVERY_WAIT_KEY));
	}
	/** vpeB plcRecoveryWait ̐ݒ胁\bhB
	 * @param plcRecoveryWait vpeB plcRecoveryWait ̐VlB
	 */
	public void setPlcRecoveryWait(int plcRecoveryWait) {
		environments.setProperty(PLC_RECOVERY_WAIT_KEY, String.valueOf(plcRecoveryWait));
	}

	/** vpeB hostNetNo ̎擾\bhB
	 * @return vpeB hostNetNo ̒lB
	 */
	public int getHostNetNo() {
		return Integer.parseInt(environments.getProperty(HOST_NET_NO_KEY));
	}
	/** vpeB hostNetNo ̐ݒ胁\bhB
	 * @param hostNetNo vpeB hostNetNo ̐VlB
	 */
	public void setHostNetNo(int hostNetNo) {
		environments.setProperty(HOST_NET_NO_KEY, String.valueOf(hostNetNo));
	}

	/** vpeB hostPortNo ̎擾\bhB
	 * @return vpeB hostPortNo ̒lB
	 */
	public int getHostPortNo() {
		return Integer.parseInt(environments.getProperty(HOST_PORT_NO_KEY));
	}
	/** vpeB hostPortNo ̐ݒ胁\bhB
	 * @param hostPortNo vpeB hostPortNo ̐VlB
	 */
	public void setHostPortNo(int hostPortNo) {
		environments.setProperty(HOST_PORT_NO_KEY, String.valueOf(hostPortNo));
	}

	/** vpeB hostIpAddress ̎擾\bhB
	 * @return vpeB hostIpAddress ̒lB
	 */
	public String getHostIpAddress() {
		return environments.getProperty(HOST_IP_ADDRESS_KEY);
	}
	/** vpeB hostIpAddress ̐ݒ胁\bhB
	 * @param hostIpAddress vpeB hostIpAddress ̐VlB
	 */
	public void setHostIpAddress(String hostIpAddress) {
		environments.setProperty(HOST_IP_ADDRESS_KEY, hostIpAddress);
	}

	/** vpeB hostAddress ̎擾\bhB
	 * @return vpeB hostAddress ̒lB
	 */
	public int getHostAddress() {
		String s = getHostIpAddress();
		if (s == null) {
			return 0;
		}
		return Integer.parseInt(s.substring(s.lastIndexOf('.') + 1));
	}

	/** vpeB plcIpAddress2 ̎擾\bhB
	 * @return vpeB plcIpAddress2 ̒lB
	 */
	public String getPlcIpAddress2() {
		return environments.getProperty(PLC_IP_ADDRESS2_KEY);
	}
	/** vpeB plcIpAddress2 ̐ݒ胁\bhB
	 * @param plcIpAddress2 vpeB plcIpAddress2 ̐VlB
	 */
	public void setPlcIpAddress2(String plcIpAddress) {
		environments.setProperty(PLC_IP_ADDRESS2_KEY, plcIpAddress);
	}

	public void setAllPropertys(String line) throws Exception {
		try {
			StringTokenizer st = new StringTokenizer(line);

			// DeviceID
			setDeviceID(st.nextToken());
			// DeviceKing
			setDeviceKind(st.nextToken());

			// UDPpvpeB
			if (getDeviceKind().equals("UDP")) {
//			if (getDeviceKind().getClass().getName().endsWith("UDP")) {
				// IpAddress
				setPlcIpAddress(st.nextToken());
				// PortNo
				setPlcPortNo(Integer.parseInt(st.nextToken()));
				// CommKind
				setPlcCommKind(st.nextToken());
				if (getPlcCommKind().equals("FINS")) {
					// NetNo
					setPlcNetNo(Integer.parseInt(st.nextToken()));
					// NodeNo
					setPlcNodeNo(Integer.parseInt(st.nextToken()));
					// UnitNo
					setPlcUnitNo(Integer.parseInt(st.nextToken()));
				}
				else if(getPlcCommKind().equals("MC3E")) {
					// NetNo
					setPlcNetNo(Integer.parseInt(st.nextToken()));
					// NodeNo
					setPlcNodeNo(Integer.parseInt(st.nextToken()));
					// Watch
					setPlcWatchWait(Integer.parseInt(st.nextToken()));
				}
				else {
					throw new Exception(" ERROR: not \"FINS\" \"MC3E\".");
				}
				// Timeout
				setPlcTimeout(Integer.parseInt(st.nextToken()));
				// RetryTime
				setPlcRetryCount(Integer.parseInt(st.nextToken()));
				// RecoveryWaitTime
				setPlcRecoveryWait(Integer.parseInt(st.nextToken()));

				// Optionݒ
				// host NetNo
				if (st.hasMoreTokens()) {
					setHostNetNo(Integer.parseInt(st.nextToken()));
				}
				else {
					// w肪Ȃꍇ 1
					setHostNetNo(1);
				}
				// host IpAddress
				if (st.hasMoreTokens()) {
					setHostIpAddress(st.nextToken());
				}
				else {
					// w肪Ȃꍇ̓[JAhX擾
					setHostIpAddress(java.net.InetAddress.getLocalHost().getHostAddress());
				}
				// host PortNo
				if (st.hasMoreTokens()) {
					setHostPortNo(Integer.parseInt(st.nextToken()));
				}
				else {
					// w肪Ȃꍇ PlcPortNo Ɠ
					setHostPortNo(getPlcPortNo());
				}

				// IpAddress2
				if (st.hasMoreTokens()) {
					setPlcIpAddress2(st.nextToken());
				}
				else {
					// w肪Ȃꍇ null
					setPlcIpAddress2(null);
				}
			}
			else if (getDeviceKind().equals("BACnet")) {
				// PortNo
				setPlcPortNo(0xBAC0);
			}
			else {
				throw new Exception(" ERROR: not \"UDP\".");
			}
		} catch(java.util.NoSuchElementException e) {
			throw new Exception(" ERROR: short of property.");
		}
	}
}
