/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.hotswap;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.seasar.framework.hotswap.HotswapClassLoader;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;

public class Hotswap
implements Externalizable {
    static final long serialVersionUID = 0L;
    private transient Class targetClass;
    private transient String path;
    private transient File file;
    private transient long lastModified;

    public Hotswap() {
    }

    public Hotswap(Class targetClass) {
        this.targetClass = targetClass;
        this.setPath(ClassUtil.getResourcePath(targetClass));
        this.lastModified = this.file.lastModified();
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.file = ResourceUtil.getResourceAsFile(path);
    }

    public File getFile() {
        return this.file;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isModified() {
        return this.lastModified > 0L && this.file.lastModified() > this.lastModified;
    }

    public Class updateTargetClass() {
        if (this.isModified()) {
            HotswapClassLoader classLoader = new HotswapClassLoader();
            this.targetClass = classLoader.defineClass(this.targetClass.getName(), this.file);
            this.lastModified = this.file.lastModified();
        }
        return this.targetClass;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.targetClass);
        out.writeUTF(this.path);
        out.writeLong(this.lastModified);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.targetClass = (Class)in.readObject();
        this.setPath(in.readUTF());
        this.lastModified = in.readLong();
    }
}

