/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.Dbms;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.NoPersistentPropertyTypeRuntimeException;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.id.IdentifierGeneratorFactory;
import org.seasar.dao.impl.DtoMetaDataImpl;
import org.seasar.dao.impl.FieldAnnotationReaderFactory;
import org.seasar.dao.impl.RelationPropertyTypeImpl;
import org.seasar.dao.impl.ValueTypeFactoryImpl;
import org.seasar.extension.jdbc.ColumnNotFoundRuntimeException;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public class BeanMetaDataImpl
extends DtoMetaDataImpl
implements BeanMetaData {
    private static Logger logger = Logger.getLogger((Class)BeanMetaDataImpl.class);
    private String tableName;
    private Map propertyTypesByColumnName = new CaseInsensitiveMap();
    private List relationPropertyTypes = new ArrayList();
    private PropertyType[] primaryKeys = new PropertyType[0];
    private String autoSelectList;
    private boolean relation;
    private IdentifierGenerator identifierGenerator;
    private String versionNoPropertyName = "versionNo";
    private String timestampPropertyName = "timestamp";
    private AnnotationReaderFactory annotationReaderFactory;
    private Dbms dbms;
    private DatabaseMetaData databaseMetaData;

    public BeanMetaDataImpl() {
    }

    public BeanMetaDataImpl(Class beanClass, DatabaseMetaData dbMetaData, Dbms dbms) {
        this(beanClass, dbMetaData, dbms, new FieldAnnotationReaderFactory(), false);
    }

    public BeanMetaDataImpl(Class beanClass, DatabaseMetaData dbMetaData, Dbms dbms, AnnotationReaderFactory annotationReaderFactory) {
        this(beanClass, dbMetaData, dbms, annotationReaderFactory, false);
    }

    public BeanMetaDataImpl(Class beanClass, DatabaseMetaData dbMetaData, Dbms dbms, AnnotationReaderFactory annotationReaderFactory, boolean relation) {
        this.setBeanClass(beanClass);
        this.setAnnotationReaderFactory(annotationReaderFactory);
        this.setRelation(relation);
        this.setValueTypeFactory(new ValueTypeFactoryImpl());
        this.initialize();
    }

    protected AnnotationReaderFactory getAnnotationReaderFactory() {
        return this.annotationReaderFactory;
    }

    public void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    public void initialize() {
        this.beanAnnotationReader = this.getAnnotationReaderFactory().createBeanAnnotationReader(this.getBeanClass());
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)this.getBeanClass());
        this.setupTableName(beanDesc);
        this.setupVersionNoPropertyName(beanDesc);
        this.setupTimestampPropertyName(beanDesc);
        this.setupProperty(beanDesc, this.databaseMetaData, this.dbms);
        this.setupDatabaseMetaData(beanDesc, this.databaseMetaData, this.dbms);
        this.setupPropertiesByColumnName();
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }

    public String getTableName() {
        return this.tableName;
    }

    public PropertyType getVersionNoPropertyType() throws PropertyNotFoundRuntimeException {
        return this.getPropertyType(this.versionNoPropertyName);
    }

    public PropertyType getTimestampPropertyType() throws PropertyNotFoundRuntimeException {
        return this.getPropertyType(this.timestampPropertyName);
    }

    public String getVersionNoPropertyName() {
        return this.versionNoPropertyName;
    }

    public String getTimestampPropertyName() {
        return this.timestampPropertyName;
    }

    public PropertyType getPropertyTypeByColumnName(String columnName) throws ColumnNotFoundRuntimeException {
        PropertyType propertyType = (PropertyType)this.propertyTypesByColumnName.get(columnName);
        if (propertyType == null) {
            throw new ColumnNotFoundRuntimeException(this.tableName, columnName);
        }
        return propertyType;
    }

    public PropertyType getPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return this.getPropertyTypeByColumnName(alias);
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        RelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        return rpt.getBeanMetaData().getPropertyTypeByColumnName(columnName);
    }

    public boolean hasPropertyTypeByColumnName(String columnName) {
        return this.propertyTypesByColumnName.get(columnName) != null;
    }

    public boolean hasPropertyTypeByAliasName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return true;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            return false;
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            return false;
        }
        if (relno >= this.getRelationPropertyTypeSize()) {
            return false;
        }
        RelationPropertyType rpt = this.getRelationPropertyType(relno);
        return rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName);
    }

    public boolean hasVersionNoPropertyType() {
        return this.hasPropertyType(this.versionNoPropertyName);
    }

    public boolean hasTimestampPropertyType() {
        return this.hasPropertyType(this.timestampPropertyName);
    }

    public String convertFullColumnName(String alias) {
        if (this.hasPropertyTypeByColumnName(alias)) {
            return this.tableName + "." + alias;
        }
        int index = alias.lastIndexOf(95);
        if (index < 0) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        String columnName = alias.substring(0, index);
        String relnoStr = alias.substring(index + 1);
        int relno = -1;
        try {
            relno = Integer.parseInt(relnoStr);
        }
        catch (Throwable t) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        RelationPropertyType rpt = this.getRelationPropertyType(relno);
        if (!rpt.getBeanMetaData().hasPropertyTypeByColumnName(columnName)) {
            throw new ColumnNotFoundRuntimeException(this.tableName, alias);
        }
        return rpt.getPropertyName() + "." + columnName;
    }

    public int getRelationPropertyTypeSize() {
        return this.relationPropertyTypes.size();
    }

    public RelationPropertyType getRelationPropertyType(int index) {
        return (RelationPropertyType)this.relationPropertyTypes.get(index);
    }

    public RelationPropertyType getRelationPropertyType(String propertyName) throws PropertyNotFoundRuntimeException {
        for (int i = 0; i < this.getRelationPropertyTypeSize(); ++i) {
            RelationPropertyType rpt = (RelationPropertyType)this.relationPropertyTypes.get(i);
            if (rpt == null || !rpt.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return rpt;
        }
        throw new PropertyNotFoundRuntimeException(this.getBeanClass(), propertyName);
    }

    protected void setupTableName(BeanDesc beanDesc) {
        String ta = this.beanAnnotationReader.getTableAnnotation();
        this.tableName = ta != null ? ta : ClassUtil.getShortClassName((Class)this.getBeanClass());
    }

    protected void setupVersionNoPropertyName(BeanDesc beanDesc) {
        String vna = this.beanAnnotationReader.getVersionNoProteryNameAnnotation();
        if (vna != null) {
            this.versionNoPropertyName = vna;
        }
    }

    protected void setupTimestampPropertyName(BeanDesc beanDesc) {
        String tsa = this.beanAnnotationReader.getTimestampPropertyName();
        if (tsa != null) {
            this.timestampPropertyName = tsa;
        }
    }

    protected void setupProperty(BeanDesc beanDesc, DatabaseMetaData dbMetaData, Dbms dbms) {
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            String idAnnotation;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            PropertyType pt = null;
            if (this.beanAnnotationReader.hasRelationNo(pd)) {
                if (!this.relation) {
                    RelationPropertyType rpt = this.createRelationPropertyType(beanDesc, pd, dbMetaData, dbms);
                    this.addRelationPropertyType(rpt);
                }
            } else {
                pt = this.createPropertyType(beanDesc, pd);
                this.addPropertyType(pt);
            }
            if (this.identifierGenerator != null || (idAnnotation = this.beanAnnotationReader.getId(pd)) == null) continue;
            this.identifierGenerator = IdentifierGeneratorFactory.createIdentifierGenerator(pd.getPropertyName(), dbms, idAnnotation);
            this.primaryKeys = new PropertyType[]{pt};
            pt.setPrimaryKey(true);
        }
    }

    protected void setupDatabaseMetaData(BeanDesc beanDesc, DatabaseMetaData dbMetaData, Dbms dbms) {
        this.setupPropertyPersistentAndColumnName(beanDesc, dbMetaData);
        this.setupPrimaryKey(dbMetaData, dbms);
    }

    protected void setupPrimaryKey(DatabaseMetaData dbMetaData, Dbms dbms) {
        if (this.identifierGenerator == null) {
            ArrayList<PropertyType> pkeyList = new ArrayList<PropertyType>();
            Set primaryKeySet = DatabaseMetaDataUtil.getPrimaryKeySet((DatabaseMetaData)dbMetaData, (String)this.tableName);
            for (int i = 0; i < this.getPropertyTypeSize(); ++i) {
                PropertyType pt = this.getPropertyType(i);
                if (primaryKeySet.contains(pt.getColumnName())) {
                    pt.setPrimaryKey(true);
                    pkeyList.add(pt);
                    continue;
                }
                pt.setPrimaryKey(false);
            }
            this.primaryKeys = pkeyList.toArray(new PropertyType[pkeyList.size()]);
            this.identifierGenerator = IdentifierGeneratorFactory.createIdentifierGenerator(null, dbms);
        }
    }

    protected void setupPropertyPersistentAndColumnName(BeanDesc beanDesc, DatabaseMetaData dbMetaData) {
        PropertyType pt;
        Set columnSet = DatabaseMetaDataUtil.getColumnMap((DatabaseMetaData)dbMetaData, (String)this.tableName).keySet();
        if (columnSet.isEmpty()) {
            logger.log("WDAO0002", new Object[]{this.tableName});
        }
        Iterator i = columnSet.iterator();
        block0: while (i.hasNext()) {
            String columnName = (String)i.next();
            String columnName2 = StringUtil.replace((String)columnName, (String)"_", (String)"");
            for (int j = 0; j < this.getPropertyTypeSize(); ++j) {
                PropertyType pt2 = this.getPropertyType(j);
                if (!pt2.getColumnName().equalsIgnoreCase(columnName2)) continue;
                PropertyDesc pd = pt2.getPropertyDesc();
                if (this.beanAnnotationReader.getColumnAnnotation(pd) != null) continue block0;
                pt2.setColumnName(columnName);
                continue block0;
            }
        }
        String[] props = this.beanAnnotationReader.getNoPersisteneProps();
        if (props != null) {
            for (int i2 = 0; i2 < props.length; ++i2) {
                pt = this.getPropertyType(props[i2].trim());
                pt.setPersistent(false);
            }
        }
        for (int i3 = 0; i3 < this.getPropertyTypeSize(); ++i3) {
            pt = this.getPropertyType(i3);
            if (columnSet.contains(pt.getColumnName())) continue;
            pt.setPersistent(false);
        }
    }

    protected void setupPropertiesByColumnName() {
        for (int i = 0; i < this.getPropertyTypeSize(); ++i) {
            PropertyType pt = this.getPropertyType(i);
            this.propertyTypesByColumnName.put(pt.getColumnName(), pt);
        }
    }

    protected RelationPropertyType createRelationPropertyType(BeanDesc beanDesc, PropertyDesc propertyDesc, DatabaseMetaData dbMetaData, Dbms dbms) {
        String[] myKeys = new String[]{};
        String[] yourKeys = new String[]{};
        int relno = this.beanAnnotationReader.getRelationNo(propertyDesc);
        String relkeys = this.beanAnnotationReader.getRelationKey(propertyDesc);
        if (relkeys != null) {
            StringTokenizer st = new StringTokenizer(relkeys, " \t\n\r\f,");
            ArrayList<String> myKeyList = new ArrayList<String>();
            ArrayList<String> yourKeyList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(58);
                if (index > 0) {
                    myKeyList.add(token.substring(0, index));
                    yourKeyList.add(token.substring(index + 1));
                    continue;
                }
                myKeyList.add(token);
                yourKeyList.add(token);
            }
            myKeys = myKeyList.toArray(new String[myKeyList.size()]);
            yourKeys = yourKeyList.toArray(new String[yourKeyList.size()]);
        }
        Class beanClass = propertyDesc.getPropertyType();
        BeanMetaDataImpl beanMetaData = new BeanMetaDataImpl();
        beanMetaData.setBeanClass(beanClass);
        beanMetaData.setDatabaseMetaData(dbMetaData);
        beanMetaData.setDbms(dbms);
        beanMetaData.setAnnotationReaderFactory(this.getAnnotationReaderFactory());
        beanMetaData.setValueTypeFactory(this.getValueTypeFactory());
        beanMetaData.setRelation(true);
        beanMetaData.initialize();
        RelationPropertyTypeImpl rpt = new RelationPropertyTypeImpl(propertyDesc, relno, myKeys, yourKeys, beanMetaData);
        return rpt;
    }

    protected void addRelationPropertyType(RelationPropertyType rpt) {
        for (int i = this.relationPropertyTypes.size(); i <= rpt.getRelationNo(); ++i) {
            this.relationPropertyTypes.add(null);
        }
        this.relationPropertyTypes.set(rpt.getRelationNo(), rpt);
    }

    public int getPrimaryKeySize() {
        return this.primaryKeys.length;
    }

    public String getPrimaryKey(int index) {
        return this.primaryKeys[index].getColumnName();
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    public synchronized String getAutoSelectList() {
        if (this.autoSelectList != null) {
            return this.autoSelectList;
        }
        this.setupAutoSelectList();
        return this.autoSelectList;
    }

    protected void setupAutoSelectList() {
        int i;
        StringBuffer buf = new StringBuffer(100);
        buf.append("SELECT ");
        boolean first = true;
        for (i = 0; i < this.getPropertyTypeSize(); ++i) {
            PropertyType pt = this.getPropertyType(i);
            if (!pt.isPersistent()) continue;
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(this.tableName);
            buf.append(".");
            buf.append(pt.getColumnName());
        }
        for (i = 0; i < this.getRelationPropertyTypeSize(); ++i) {
            RelationPropertyType rpt = this.getRelationPropertyType(i);
            BeanMetaData bmd = rpt.getBeanMetaData();
            for (int j = 0; j < bmd.getPropertyTypeSize(); ++j) {
                PropertyType pt = bmd.getPropertyType(j);
                if (!pt.isPersistent()) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                String columnName = pt.getColumnName();
                buf.append(rpt.getPropertyName());
                buf.append(".");
                buf.append(columnName);
                buf.append(" AS ");
                buf.append(columnName).append("_").append(rpt.getRelationNo());
            }
        }
        if (first) {
            throw new NoPersistentPropertyTypeRuntimeException();
        }
        this.autoSelectList = buf.toString();
    }

    public boolean isRelation() {
        return this.relation;
    }

    public void setRelation(boolean relation) {
        this.relation = relation;
    }

    public void setDatabaseMetaData(DatabaseMetaData databaseMetaData) {
        this.databaseMetaData = databaseMetaData;
    }
}

