/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.DataProviderDoesNotSupportException;
import jp.gr.javacons.jim.DataValueChangeEvent;
import jp.gr.javacons.jim.DataValueChangeListener;
import jp.gr.javacons.jim.Manager;
import jp.gr.javacons.jim.QualityFlag;

public class DataHolder
implements Serializable {
    static final long serialVersionUID = -8935847534554009807L;
    private String dataHolderName;
    private DataProvider dataProvider;
    private Class valueClass;
    private transient Object value;
    private transient Date timeStamp;
    private transient QualityFlag qualityFlag;
    private transient EventListenerList valueListeners;
    private Map parameters;

    public synchronized boolean addDataValueChangeListener(DataValueChangeListener listener) {
        if (this.valueListeners == null) {
            this.valueListeners = new EventListenerList();
        }
        this.valueListeners.add(DataValueChangeListener.class, listener);
        return false;
    }

    public void asyncRead() throws DataProviderDoesNotSupportException {
        if (this.dataProvider == null) {
            throw new IllegalStateException("Not owned by a DataProvider");
        }
        this.dataProvider.asyncRead(this);
    }

    public void asyncWrite() throws DataProviderDoesNotSupportException {
        if (this.dataProvider == null) {
            throw new IllegalStateException("Not owned by a DataProvider");
        }
        this.dataProvider.asyncWrite(this);
    }

    protected boolean canSetDataHolderName(String name) {
        if (this.dataProvider == null) {
            return !Manager.containsInvalidCharacter(name);
        }
        if (name == null || "".equals(name)) {
            return false;
        }
        return this.dataProvider.canSetDataHolderName(this, name);
    }

    public boolean containsParameterName(String paraName) {
        if (this.parameters == null) {
            return false;
        }
        return this.parameters.containsKey(paraName);
    }

    public String getDataHolderName() {
        return this.dataHolderName;
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public Object getParameter(String paraName) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(paraName);
    }

    public String[] getParameterNames() {
        if (this.parameters == null) {
            return new String[0];
        }
        Set keySet = this.parameters.keySet();
        return keySet.toArray(new String[0]);
    }

    public QualityFlag getQualityFlag() {
        return this.qualityFlag;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public synchronized boolean isDataValueChangeListenersEmpty() {
        if (null == this.valueListeners) {
            return true;
        }
        return 0 == this.valueListeners.getListenerCount(DataValueChangeListener.class);
    }

    public synchronized boolean removeDataValueChangeListener(DataValueChangeListener listener) {
        if (this.valueListeners == null) {
            return false;
        }
        this.valueListeners.remove(DataValueChangeListener.class, listener);
        return false;
    }

    public void setDataHolderName(String newName) {
        if (!this.canSetDataHolderName(newName)) {
            throw new IllegalArgumentException("newName is illegal");
        }
        String oldN = this.getDataHolderName();
        if (oldN == null || !oldN.equals(newName)) {
            this.dataHolderName = newName;
            if (this.dataProvider != null) {
                Manager.getInstance().notifyDataHolderRenamed(this.dataProvider, this, newName, oldN);
            }
        }
    }

    public void setDataProvider(DataProvider dp) {
        if (dp == null) {
            this.dataProvider = dp;
            return;
        }
        if (dp.getDataHolder(this.getDataHolderName()) != this) {
            throw new IllegalArgumentException("owned by a incorrect DataProvider");
        }
        this.dataProvider = dp;
    }

    public void setParameter(String[] paraNames, Object[] paraValues) {
        String paraName;
        int i;
        for (i = 0; i < paraNames.length; ++i) {
            paraName = paraNames[i];
            if (paraName != null && !"".equals(paraName)) continue;
            throw new IllegalArgumentException("parameter name should not be empty string nor null");
        }
        if (this.parameters == null) {
            this.parameters = new HashMap(paraNames.length);
        }
        for (i = 0; i < paraNames.length; ++i) {
            paraName = paraNames[i];
            Object paraValue = paraValues[i];
            Object oldVal = this.getParameter(paraName);
            if (oldVal == paraValue || oldVal != null && oldVal.equals(paraValue)) continue;
            this.parameters.put(paraName, paraValue);
        }
    }

    public void setParameter(String paraName, Object paraValue) {
        if (paraName == null || "".equals(paraName)) {
            throw new IllegalArgumentException("parameter name should not be empty string nor null");
        }
        if (this.parameters == null) {
            this.parameters = new HashMap(5);
        }
        this.parameters.put(paraName, paraValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object val, Date ts, QualityFlag qf) {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            this.value = val;
            this.timeStamp = ts;
            this.qualityFlag = qf;
        }
        if (this.valueListeners == null) {
            return;
        }
        DataValueChangeEvent e = new DataValueChangeEvent(this, val, ts, qf);
        Object[] listeners = this.valueListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$jp$gr$javacons$jim$DataValueChangeListener == null ? DataHolder.class$("jp.gr.javacons.jim.DataValueChangeListener") : class$jp$gr$javacons$jim$DataValueChangeListener)) continue;
            ((DataValueChangeListener)listeners[i + 1]).dataValueChanged(e);
        }
    }

    public void setValueClass(Class valueClass) {
        if (valueClass == null) {
            throw new IllegalArgumentException("\"valueClass\" should not be null");
        }
        if (this.dataProvider != null) {
            Class[][] dhInfo = this.dataProvider.getProvidableDataHolderTypeInfo();
            boolean flg = false;
            for (int i = 0; i < dhInfo.length; ++i) {
                for (int j = 1; j < dhInfo[i].length; ++j) {
                    if (dhInfo[i][j] != valueClass) continue;
                    flg = true;
                    break;
                }
                if (flg) break;
            }
            if (!flg) {
                throw new IllegalStateException("\"valueClass\" can not be provided by the owner DataProvider");
            }
        }
        if (this.value != null && valueClass.isInstance(this.value)) {
            throw new IllegalArgumentException("\"valueClass\" is incompatible with value");
        }
        this.valueClass = valueClass;
    }

    public void syncRead() throws DataProviderDoesNotSupportException {
        if (this.dataProvider == null) {
            throw new IllegalStateException("Not owned by a DataProvider");
        }
        this.dataProvider.syncRead(this);
    }

    public void syncWrite() throws DataProviderDoesNotSupportException {
        if (this.dataProvider == null) {
            throw new IllegalStateException("Not owned by a DataProvider");
        }
        this.dataProvider.syncWrite(this);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("dataHolderName=").append(this.dataHolderName).append(", dataProvider=").append(this.dataProvider).append(", valueClass=").append(this.valueClass).append(", value=").append(this.value).append(", timeStamp=").append(this.timeStamp);
        return b.toString();
    }
}

