/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.text.CollationKey;
import java.text.Collator;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.DataProviderCustomizerHelper;
import jp.gr.javacons.jim.DefaultDataProviderCustomizerHelper;

final class Utility {
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();

    private Utility() {
    }

    public static DataProviderCustomizerHelper getDataProviderCustomizerHelper(DataProvider dp) {
        try {
            Class cls = (Class)Introspector.getBeanInfo(dp.getClass()).getBeanDescriptor().getValue("JIMDataProviderCustomizerHelper");
            if (cls != null) {
                return (DataProviderCustomizerHelper)cls.newInstance();
            }
        }
        catch (IntrospectionException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new DefaultDataProviderCustomizerHelper();
    }

    public static Frame getRootFrame(Component component) {
        Component c = component;
        do {
            if ((c = c.getParent()) != null) continue;
            c = new Frame();
        } while (!(c instanceof Frame));
        return (Frame)c;
    }

    public static void setScreenCenter(Window window) {
        Dimension d = toolkit.getScreenSize();
        Rectangle r = window.getBounds();
        r.x = (d.width - r.width) / 2;
        r.y = (d.height - r.height) / 2;
        window.setBounds(r);
    }

    public static void showMessage(Frame parent, String message) {
        new MessageDialog(parent, "Warning", message).show();
    }

    public static void sort(Object[] src, Object[] dest, int low, int high, Comparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Utility.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Utility.sort(dest, src, low, mid, c);
        Utility.sort(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    public static void sort(Object[] a, Comparator c) {
        Object[] aux = (Object[])a.clone();
        Utility.sort(aux, a, 0, a.length, c);
    }

    public static String[] sort(String[] src) {
        int size = src.length;
        Collator col = Collator.getInstance();
        Object[] keys = new CollationKey[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = col.getCollationKey(src[i]);
        }
        Object[] target = new CollationKey[size];
        System.arraycopy(keys, 0, target, 0, size);
        Utility.sort(keys, target, 0, size, new Comparator(){

            int compare(Object o1, Object o2) {
                CollationKey k1 = (CollationKey)o1;
                CollationKey k2 = (CollationKey)o2;
                return k1.compareTo(k2);
            }
        });
        String[] str = new String[size];
        for (int i = 0; i < size; ++i) {
            str[i] = ((CollationKey)target[i]).getSourceString();
        }
        return str;
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    static abstract class Comparator {
        Comparator() {
        }

        abstract int compare(Object var1, Object var2);
    }

    static class MessageDialog
    extends Dialog {
        private static final long serialVersionUID = 7662687878445634735L;

        MessageDialog(Frame parent, String title, String message) {
            super(parent, title, true);
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)new Panel(), "North");
            this.add((Component)new Panel(), "West");
            this.add((Component)new Panel(), "East");
            Panel p = new Panel();
            Label l = new Label(message, 1);
            this.add((Component)l, "Center");
            p = new Panel();
            Button b = new Button("OK");
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.dispose();
                }
            });
            p.add(b);
            this.add((Component)p, "South");
            this.pack();
            Utility.setScreenCenter(this);
            toolkit.beep();
        }
    }
}

