package org.F11.scada.tool.alist.history;

import java.rmi.Naming;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.F11.scada.WifeUtilities;
import org.F11.scada.data.DataAccessable;
import org.F11.scada.tool.login.PermissionCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * @author maekawa
 */
public class UpdateAllCheckAction extends Action {
	private static final String ERROR_MSG = "SmFDBXVɃG[܂";
	private final Log log = LogFactory.getLog(UpdateAllCheckAction.class);

	public ActionForward execute(
			ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		if (!PermissionCheck.check("career", request))
			return (mapping.getInputForward());

		String collectorServer = WifeUtilities.createRmiManagerDelegator();
		try {
			DataAccessable alarmRef =
				(DataAccessable) Naming.lookup(collectorServer);
			alarmRef.invoke("HistoryAllCheck", new Object[0]);
		} catch (Exception ex) {
			log.error(ERROR_MSG, ex);
			ActionErrors errors = new ActionErrors();
			ActionError error = new ActionError("error.db.update", ERROR_MSG);
			errors.add(ActionErrors.GLOBAL_ERROR, error);
			saveErrors(request, errors);
			return mapping.findForward("historyInitList");
		}

		log.info("SmFI");
		return (mapping.findForward("continue"));
	}
}
