/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.tool.page.bar2;

import java.rmi.RemoteException;

import org.F11.scada.tool.io.PageListBean;
import org.F11.scada.tool.page.parser.DOMPageDefine;
import org.F11.scada.tool.page.parser.bar2.BarGraph2Define;
import org.F11.scada.util.RmiUtil;

public class Bar2ServiceImpl implements Bar2Service {
	public Bar2ServiceImpl(int regport, int objport) {
		RmiUtil.registryServer(this, Bar2Service.class, regport, objport);
	}

	public void setBar(PageListBean page, Bar2PointForm actionForm)
			throws RemoteException {
		try {
			DOMPageDefine pageDefine = new DOMPageDefine(page.getPageXmlPath());
			BarGraph2Define bar2Define = pageDefine.getBarGraph2Define();
			bar2Define.setBarPoint(actionForm);
			pageDefine.send();
		} catch (Exception e) {
			throw new RemoteException("o[`MɃG[ : ", e);
		}
	}
}
