/*
 * Created on 2003/08/25
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code Template
 */
package org.F11.scada.tool.page.trend.item;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.F11.scada.server.frame.editor.TaskItemDefine;
import org.F11.scada.tool.login.PermissionCheck;
import org.F11.scada.tool.page.parser.trend.SeriesBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.seasar.dao.pager.PagerSupport;
import org.seasar.dao.pager.PagerViewHelper;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/**
 * @author hori
 */
public class GetTrendItemListAction extends Action {
	protected Log log = LogFactory.getLog(this.getClass());
	/** y[WT|[gNX */
	private PagerSupport pager =
		new PagerSupport(50, TaskItemCondition.class, "taskItemCondition");
	private TaskItemService service;

	public ActionForward execute(
			ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		if (!PermissionCheck.check("page", request))
			return (mapping.getInputForward());

		if (isPossionInvalid(request)) {
			return (mapping.getInputForward());
		} else {
			request.setAttribute("pos", Integer.valueOf(request
				.getParameter("pos")));
		}

		try {
			pager.updateOffset(request);
			TaskItemCondition condition = getCondition(form, request);
			List<TaskItemDefine> itemList = getItemList(request, condition);
			request.setAttribute("loggItemList", itemList);
			PagerViewHelper helper = new PagerViewHelper(condition);
			request.setAttribute("viewHelper", helper);
		} catch (Exception e) {
			ActionErrors errors = new ActionErrors();
			errors.add(ActionErrors.GLOBAL_ERROR, new ActionError(
				"error.page.item.notget"));
			saveErrors(request, errors);
			return (mapping.getInputForward());
		}

		return (mapping.findForward("continue"));
	}

	private boolean isPossionInvalid(HttpServletRequest request) {
		String strPos = request.getParameter("pos");
		return strPos == null || strPos.length() <= 0;
	}

	private TaskItemCondition getCondition(
			ActionForm form,
			HttpServletRequest request) {
		TaskItemCondition condition =
			(TaskItemCondition) pager.getPagerCondition(request);
		DynaValidatorForm actionForm = (DynaValidatorForm) form;
		String unit = (String) actionForm.get("searchunit");
		condition.setUnit(unit);
		String name = (String) actionForm.get("searchname");
		condition.setName(name);
		String unitMark = (String) actionForm.get("searchunit_mark");
		condition.setUnitMark(unitMark);
		return condition;
	}

	private List<TaskItemDefine> getItemList(
			HttpServletRequest request,
			TaskItemCondition condition) throws Exception {
		HttpSession session = request.getSession();
		SeriesBean series = (SeriesBean) session.getAttribute("trendSeries");
		setService();
		List<TaskItemDefine> itemList =
			service.getTaskItemDefine(series.getHandlerName(), condition);
		return itemList;
	}

	private void setService() {
		if (null == service) {
			S2Container container = SingletonS2ContainerFactory.getContainer();
			service =
				(TaskItemService) container.getComponent(TaskItemService.class);
		}
	}
}
