/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2008 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

package org.F11.scada.tool.page.trend.item;

import static org.F11.scada.util.AttributesUtil.getLikeString;

import java.util.List;

import org.seasar.dao.pager.DefaultPagerCondition;

public class TaskItemCondition extends DefaultPagerCondition {
	private static final long serialVersionUID = 710687333861786541L;
	private String unit;
	private String name;
	private String unitMark;
	private List<String> providers;
	private List<String> holders;

	public String getUnit() {
		return getLikeString(unit);
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getName() {
		return getLikeString(name);
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getUnitMark() {
		return getLikeString(unitMark);
	}

	public void setUnitMark(String unitMark) {
		this.unitMark = unitMark;
	}

	public List<String> getProviders() {
		return providers;
	}

	public void setProviders(List<String> providers) {
		this.providers = providers;
	}

	public List<String> getHolders() {
		return holders;
	}

	public void setHolders(List<String> holders) {
		this.holders = holders;
	}

	@Override
	public String toString() {
		return String.format(
			"unit=%s, name=%s, unitMark=%s, providers=%s, holders=%s%n",
			unit,
			name,
			unitMark,
			providers.toString(),
			holders.toString());
	}
}
