/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2008 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

package org.F11.scada.tool.page.trend.item;

import java.util.List;

import org.F11.scada.cat.util.CollectionUtil;
import org.F11.scada.server.frame.editor.TaskItemDefine;
import org.seasar.dao.unit.S2DaoTestCase;

public class TaskItemDaoTest extends S2DaoTestCase {
	private TaskItemDao dao;

	protected void setUp() throws Exception {
		include("TaskItemDao.dicon");
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetAnalogNameList() {
		TaskItemCondition condition = new TaskItemCondition();
		List<String> providers = CollectionUtil.list("P1", "P2");
		List<String> holders = CollectionUtil.list("D_500_BcdSingle", "D_501_BcdSingle", "D_502_BcdSingle");
		condition.setProviders(providers);
		condition.setHolders(holders);
		List<TaskItemDefine> l = dao.getAnalogNameList(condition);
		System.out.println(l);
		assertEquals(3, l.size());
	}
}
