#!/bin/busybox sh
# Usage: 
#
#   on local(kobo) :
# tmpuu=`mktemp /tmp/eKB_XXXXXX`
# $0 | tee $tmpuu | sed '/^begin-base64 644/,$d'
# sed -n '/^begin-base64 644/,$p' $tmpuu | uudecode
# rm -f $tmpuu
#
#   on remote :
# tmpuu=`mktemp /tmp/eKB_XXXXXX`
# ssh kobo $0 | tee $tmpuu | sed '/^begin-base64 644/,$d'
# sed -n '/^begin-base64 644/,$p' $tmpuu | uudecode
# rm -f $tmpuu
#

easyKoboBackupVer=4

################
bindir="$(readlink -f "$0")"; bindir="${bindir%/*}"
addVerCheck_sh="$bindir/addVerCheck.sh"
koboBackup_sh="$bindir/koboBackup.sh"
wrappingMD_sh="$bindir/wrapping-mount-dosfsck.sh"
[ -x "$addVerCheck_sh" -a -x "$koboBackup_sh" ] || exit 1

wd=$(mktemp -d /tmp/easyKoboBackup_XXXXXX)
cd $wd
uuid=`dbus-uuidgen`

## make aux:tar
mkdir -m 755 -p tmp/ekb_$uuid
cp "$wrappingMD_sh" tmp/ekb_$uuid/
img_kb_dir="${FKSH_ONB:-/mnt/onboard/.fakesh}/images/koboBackup"
cp "$img_kb_dir"/*.raw.gz tmp/ekb_$uuid/
chmod 644 tmp/ekb_$uuid/*.raw.gz
tar cf wrap_n_images.tar ./tmp/ekb_$uuid/${wrappingMD_sh##*/} \
  ./tmp/ekb_$uuid/*.raw.gz
rm -rf ./tmp

## versions.lst
cat > versions.lst << EOVERLST
name: easyKoboBackup$easyKoboBackupVer
script:dst: /tmp/ekb_$uuid/koboBackup-oneShot.sh
script:pre: cat '$koboBackup_sh'
script:exe: /tmp/ekb_$uuid/koboBackup-oneShot.sh YES
aux:tar: wrap_n_images.tar
firmware_version,hardware comment
*,* all versions
EOVERLST
##

$addVerCheck_sh 2>&1
[ -f KoboRoot.tgz ] || exit 3
uuencode -m KoboRoot.tgz KoboRoot.tgz
cd /tmp
rm -rf $wd
exit

