#!/bin/busybox sh

case "${0##*/}" in
deb*) cmd=X ;;
*) cmd="$1"; shift ;;
esac

case "$cmd" in
[txXT]) ;;
*) showUsage ;;
esac 1>&2

showUsage () {
  case "${0##*/}" in
  deb*) cat <<- EOUSAGE1
	Usage: ${0##*/} file.deb [tar_options ...]  # deb extract
	       ${0##*/} file.deb --list             # deb listing
	EOUSAGE1
  ;;
  *) cat <<- EOUSAGE2
	Usage: ${0##*/} t file.a                     # ar listing
	       ${0##*/} x file.a [filename ...]      # ar extract
	       ${0##*/} T file.deb [tar_options ...] # deb listing
	       ${0##*/} X file.deb [tar_options ...] # deb extract
	EOUSAGE2
  ;;
  esac 1>&2
  exit 1
}

[ $# -eq 0 ] && showUsage
deb="$1"; shift

# Usage: binAccess offset size
binAccess () {
  local p sz
  ## stupid dd
  if [ $1 -eq 0 ] ; then
    dd if="$deb" bs=$2 count=1
  else
    p=$1; sz=$2
    while [ $sz -gt 0 ] ; do
      if [ $((2*p)) -le $sz ] ; then
        dd if="$deb" bs=$p skip=1 count=2
        sz=$((sz-2*p)); p=$((3*p))
      elif [ $p -le $sz ] ; then
        dd if="$deb" bs=$p skip=1 count=1
        sz=$((sz-p)); p=$((2*p))
      else
        dd if="$deb" bs=$p skip=1 count=1 |
          dd bs=$sz count=1
        sz=0
      fi
    done | dd bs=4096
  fi 2>/dev/null
}

magicAR="$(printf '!<arch>\n' | od -v -A n -t x)"
if [ "$magicAR" != "$(binAccess 0 8 | od -v -A n -t x)" ] ; then
  echo "not .a nor .deb archive: $deb" 1>&2
  exit 1
fi

sz=$(stat -c %s "$deb"); sz=$((sz-60))
p=8
while [ $p -lt $sz ] ; do
  p=$((p + p%2)) ## alignment
  fname=''; fsize='';
  eval $(binAccess $p 60 | awk '{
      printf "fname=\"%s\";fsize=%d", $1, $6;
      exit
    }')
  if [ -z "$fname" -o -z "$fsize" ] ; then
    echo "read Header error" 1>&2
    exit 1
  fi
  case "$cmd" in
  t)
    p=$((p+60+fsize))
    echo "$fname"
  ;;
  x)
    p=$((p+60))
    if [ $# -eq 0 ] ; then
      binAccess $p $fsize > "$fname"
    else
      for x do [ "$x" = "$fname" ] && binAccess $p $fsize > "$fname" ; done
    fi
    p=$((p+fsize))
  ;;
  [XT])
    p=$((p+60))
    case "$fname" in
    data.tar) tarcmd=f ;;
    data.tar.gz | data.tgz) tarcmd=fz ;;
    data.tar.bz2) tarcmd=fj ;;
    data.tar.xz | data.tar.lzma) tarcmd=fa ;;
    *) p=$((p+fsize)) ; continue ;;
    esac
    if [ "x$1" = x--list ] ; then
      shift
      tarcmd=t$tarcmd
    elif [ $cmd = T ] ; then
      tarcmd=t$tarcmd
    else
      tarcmd=x$tarcmd
    fi
    binAccess $p $fsize | tar $tarcmd - "$@"
    exit
  esac
done

exit
