
; -----------------------------------------------------------------------
; TEST_ASM.f
; -----------------------------------------------------------------------
\
\ TARGET SELECTION
\ MSP_EXP430FR5739  MSP_EXP430FR5969    MSP_EXP430FR5994    MSP_EXP430FR6989
\ MSP_EXP430FR4133  MSP_EXP430FR2433    MSP_EXP430FR2355    CHIPSTICK_FR2433
\
\ PUSHM order : PSP,TOS, IP,  S,  T,  W,  X,  Y, rEXIT,rDOVAR,rDOCON, rDODOES, R3, SR,RSP, PC
\ PUSHM order : R15,R14,R13,R12,R11,R10, R9, R8,  R7  ,  R6  ,  R5  ,   R4   , R3, R2, R1, R0
\
\ example : PUSHM #6,IP pushes IP,S,T,W,X,Y registers to return stack
\
\ POPM  order :  PC,RSP, SR, R3, rDODOES,rDOCON,rDOVAR,rEXIT,  Y,  X,  W,  T,  S, IP,TOS,PSP
\ POPM  order :  R0, R1, R2, R3,   R4   ,  R5  ,  R6  ,  R7 , R8, R9,R10,R11,R12,R13,R14,R15
\
\ example : POPM #6,IP   pop Y,X,W,T,S,IP registers from return stack
\
\ ASSEMBLER conditionnal usage after IF UNTIL WHILE : S< S>= U< U>= 0= 0<> 0>=
\ ASSEMBLER conditionnal usage before ?JMP ?GOTO    : S< S>= U< U>= 0= 0<> 0< 
\
\ FORTH conditionnal    : 0= 0< = < > U<

\ -----------------------------------------------------------------------
\ test CPUx instructions PUSHM, POPM, RLAM, RRAM, RRCM, RRUM
\ -----------------------------------------------------------------------
CODE TESTPUSHM
\            PUSHM  #16,R14     \ uncomment to test error "out of bounds"
\            PUSHM  #2,R0       \ uncomment to test error "out of bounds"
\            PUSHM  #0,IP       \ uncomment to test error "out of bounds"
\            POPM   #17,R15     \ uncomment to test error "out of bounds"
\            POPM   #2,R0       \ uncomment to test error "out of bounds"
\            POPM   #0,IP       \ uncomment to test error "out of bounds"
            MOV     #22222,Y
            MOV     #3,X
            MOV     #2,W
            MOV     #1,T
            MOV     #0,S

            PUSHM   #4,IP       \ PUSHM IP,S,T,W
            POPM    #4,IP       \ POPM  W,T,S,IP
            SUB     #10,PSP
            MOV     TOS,8(PSP)  \ save old TOS
            MOV     S,6(PSP)
            MOV     T,4(PSP)
            MOV     W,2(PSP)
            MOV     X,0(PSP)
            MOV     Y,TOS
\            RLAM    #0,TOS      \ uncomment to test error "out of bounds" 
\            RLAM    #5,TOS      \ uncomment to test error "out of bounds" 
            RRAM    #1,TOS      \ 0 < shift value < 5
            RLAM    #2,TOS
            RRCM    #1,TOS
            RRUM    #1,TOS
            COLON               \ high level part of the word starts here...
            space . . . . .
            ;                   \ and finishes here.
    \
TESTPUSHM  ; you should see 11111 3 2 1 0 -->

CODE TESTPOPM
            JMP TESTPUSHM
ENDCODE

    \
TESTPOPM  ; you should see 11111 3 2 1 0 -->



\ -----------------------------------------------------------------------
\ test symbolic branch in assembler
\ test a FORTH section encapsulated in an assembly word
\ -----------------------------------------------------------------------
CODE TEST1                  \ the word "CODE" add ASSEMBLER as CONTEXT vocabulary...

            MOV &BASE,&BASE \ to test &xxxx src operand
            CMP #%10,&BASE
0<> IF      MOV #2,&BASE    \ if base <> 2
ELSE        MOV #$0A,&BASE  \ else base = 2
THEN        
            COLON           \ tips : no "ok" displayed in start of line <==> compilation mode
            BASE @ U.       \ always display 10 !
            ;
    \

\ -----------------------------------------------------------------------
\ test a word that starts as word FORTH and ends as assembly word
\ -----------------------------------------------------------------------
: TEST2                     \ ":" starts compilation
            BASE @ U.       \ always display 10 !
            HI2LO           \ switch FORTH to ASM : compile one word (next address)
                            \                       add vocabulary ASSEMBLER as CONTEXT vocabulary
                            \                       switch in interpret mode
            CMP #2, &BASE
0<> IF      MOV #2, &BASE   \ if variable system BASE <> 2
ELSE        MOV #10,&BASE   \ else (BASE = 2)
THEN
\           MOV #EXIT,PC    \ to pair with ":" i.e. to restore IP saved by : then execute NEXT. 
\ but even compile two words, it's better to compile an inline EXIT :
            MOV @RSP+,IP    \ restore IP
            MOV @IP+,PC     \ = NEXT
ENDCODE                     \ ends assembler : remove vocabulary ASSEMBLER from CONTEXT
    \

\ -----------------------------------------------------------------------
\ test a word that starts as assembly word and ends as FORTH word
\ -----------------------------------------------------------------------
CODE TEST3                  \ "CODE" starts assembler, i.e. add ASSEMBLER as CONTEXT vocabulary
            CMP #2, &BASE
0<> IF      MOV #2, &BASE   \ if variable system BASE <> 2
ELSE        MOV #10,&BASE   \ else (BASE = 2)
THEN        COLON           \
            BASE @  U.      \ always display 10 !
;                           \
    \


\ -----------------------------------------------------------------------
\ test an assembly jump spanning a section written in FORTH
\ -----------------------------------------------------------------------
: TEST5
            SPACE
            HI2LO
            SUB #2,PSP
            MOV TOS,0(PSP)
            MOV #%1010,TOS  \ init count = 10
BEGIN       SUB #$0001,TOS
            LO2HI
                            \ IP is already saved by word ":"
            DUP U.          \ display count
            HI2LO
            CMP #0,TOS
0= UNTIL    MOV @PSP+,TOS
\           MOV #EXIT,PC    \ to pair with ":" i.e. to restore IP saved by : then execute NEXT. 
            MOV @RSP+,IP    \ restore IP
            MOV @IP+,PC     \ = NEXT
ENDCODE
    \
TEST5  ; you should see :  9 8 7 6 5 4 3 2 1 0 -->
    \

\ -----------------------------------------------------------------------
\ tests indexing address
\ -----------------------------------------------------------------------

: BYTES_TABLE_IDX
CREATE 
0 DO I C,
LOOP
DOES>
+
;

8 BYTES_TABLE_IDX BYTES_TABLE \ create table "BYTES_TABLE" with bytes content = 0,1,2,3,4,5,6,7
    \
2 BYTES_TABLE C@ . ; you should see 2 -->
\


VARIABLE BYTES_TABLE1

$0201 BYTES_TABLE1 !              \ words written in memory are little endian !

CODE IDX_TEST1                     \ index -- value
    MOV.B   BYTES_TABLE1(TOS),TOS  \ -- value
COLON
    U. 
;      

0 IDX_TEST1     ; you should see 1 -->

CODE TEST6
            MOV 0(PSP),0(PSP)  \
            MOV @IP+,PC
ENDCODE


1 TEST6 .       ; you should see 1 -->


\ -----------------------------------------------------------------------
\ tests access to a CREATED word with assembler 
\ -----------------------------------------------------------------------


    \
CREATE TABLE0
0 C,
1 C,
2 C,
3 C,
    \

CREATE TABLE10
$10 C,
$11 C,
$12 C,
$13 C,

    \

CREATE TABLE20
$20 C,
$21 C,
$22 C,
$23 C,
    \

CREATE TABLE


TABLE 2 - CONSTANT PFA_TABLE      \ PFA_TABLE leave the PFA of TABLE


CODE REDIRECT       ; <table> --    redirects TABLE to argument <table>    
MOV TOS,&PFA_TABLE
MOV @PSP+,TOS
MOV @IP+,PC
ENDCODE
    \

CODE REDIRECT0      ; --            redirects TABLE to TABLE0        
MOV #TABLE0,&PFA_TABLE
MOV @IP+,PC
ENDCODE
    \

CODE REDIRECT10     ; --            redirects TABLE to TABLE10        
MOV #TABLE10,&PFA_TABLE
MOV @IP+,PC
ENDCODE
    \

CODE REDIRECT20     ; --            redirects TABLE to TABLE20        
MOV #TABLE20,&PFA_TABLE
MOV @IP+,PC
ENDCODE
    \

' TABLE0 10 DUMP
    \
' TABLE10 10 DUMP
    \
' TABLE20 10 DUMP
    \
    \
TABLE0 REDIRECT TABLE 10 DUMP
    \
TABLE10 REDIRECT TABLE 10 DUMP
    \
TABLE20 REDIRECT TABLE 10 DUMP
    \
    \
REDIRECT0 TABLE 10 DUMP
    \
REDIRECT10 TABLE 10 DUMP
    \
REDIRECT20 TABLE 10 DUMP
    \

TABLE0 PFA_TABLE ! TABLE 10 DUMP
    \
TABLE10 PFA_TABLE ! TABLE 10 DUMP
    \
TABLE20 PFA_TABLE ! TABLE 10 DUMP
    \

\ -----------------------------------------------------------------------
\ tests behaviour of assembly error 
\ -----------------------------------------------------------------------
\ R16 causes an error, assembler context is aborted and the word TEST7 is "hidden".

\CODE TEST7
\           MOV 0(truc),0(R16)  ; display an error "out of bounds" -->

; -----------------------------------------------------------------------
; create a primary DEFERred assembly word
; -----------------------------------------------------------------------

DEFER TRUC              ; here, TRUC is a secondary DEFERred word (i.e. without BODY)
    \

CODENNM                 ; leaves its execution address (CFA) on stack
    SUB #2,PSP
    MOV TOS,0(PSP)
    MOV @IP+,PC
ENDCODE 
DUP . IS TRUC         ; TRUC becomes a primary DEFERred word
                        ; with its default action (DUP) located at its BODY addresse.
    \
TRUC .                  ; display TOS value -->
    \

' TRUC >BODY IS TRUC    ; TRUC is reinitialzed with its default action
    \

TRUC .                  ; display TOS value --> 
    \
' DROP IS TRUC          ; TRUC is redirected to DROP
    \
TRUC                   ; The generated error displays stack empty! in reverse video, removes the TRUC definition and restarts the interpretation after the end of the file. And as you see, FastForth is able to display long lines, interesting, doesn't it? --> 
   
bla
bla
bla







bla
...




