#! /usr/bin/env python
"""find and kill processes
"""
import pexpect
import re
import sys
import os

def main(proc):
    child = pexpect.spawn('ps aucxwww')
    child.setwinsize(100,300)
    child.expect(pexpect.EOF)

    pslist =  child.before.splitlines()
    # separate string by space
    fmt = re.split(' +', pslist[0])

    if fmt[-1] == '':
        fmt.pop()
    if fmt[0] == '':
        fmt.pop(0)
    lenfmt = len(fmt)

    # indexing, key is format of output of ps command, value is number of list
    index = dict([(k,v) for (k,v) in zip(fmt, range(0,lenfmt))])

    # find ".*<processname>.*" in 'COMMAND' part
    pars = re.compile(".*"+proc+".*")
    
    for l in pslist[1:]:
        elm = re.split(' +',l ,lenfmt)
        cmd = elm[index['COMMAND']]
        result = pars.match(cmd)

        if (result is not None):
            os.system('kill -KILL ' + elm[index['PID']])
            print 'stop', elm[index['PID']], ':', cmd


if __name__== "__main__":
    if (len(sys.argv) != 2):
        print "Usage : %s <process_name>" % sys.argv[0]
        sys.exit(1)

    main(sys.argv[1])

