// Java3DProgram.java

import java.applet.Applet;
import com.sun.j3d.utils.applet.MainFrame;
import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.*;

import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;

/*
    <applet code=Java3DProgram width=200 height=200>
    </applet>
*/

public class Java3DProgram extends Applet {

    public SimpleUniverse universe = null;
    public Canvas3D canvas = null;

    public BranchGroup createObjects() {

        BranchGroup root = new BranchGroup();

        // 平行移動を定義
        TransformGroup transRoot = new TransformGroup();
        Transform3D transform = new Transform3D();

        // x方向に1.0m移動
        transform.set(new Vector3d(1.0, 0, 0));
        transRoot.setTransform(transform);

        // 色つき立方体の作成
        transRoot.addChild(new ColorCube(0.4));
        root.addChild(transRoot);
        root.compile();

        return root;
    }

    public void setOrbitBehavior() {

        // マウスでぐりぐりするための処理
        OrbitBehavior orbit = new OrbitBehavior(canvas, OrbitBehavior.REVERSE_ALL);
        orbit.setSchedulingBounds(
            new BoundingSphere(new Point3d(0, 0, 0), 100.0));
        universe.getViewingPlatform().setViewPlatformBehavior(orbit);
    }

    public void init() {

        setLayout(new BorderLayout());

        // キャンバスの作成
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(config);
        add("Center", canvas);

        // SimpleUniverse の作成
        universe = new SimpleUniverse(canvas);

        // カメラの移動(原点から少しだけ後ろにずれる)
        universe.getViewingPlatform().setNominalViewingTransform();

        // マウスでぐりぐり動かすための処理
        setOrbitBehavior();

        // オブジェクトの追加
        universe.addBranchGraph(createObjects());
    }

    public static void main(String[] args) {
        new MainFrame(new Java3DProgram(), 200, 200);
    }
}