import javax.swing.*;
import java.awt.event.*;
import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;
import com.sun.j3d.utils.universe.*;
import javax.media.j3d.*;
//import javax.vecmath.*;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;

public class Sample3D extends JFrame {
        public BranchGroup createSceneGraph() {
		BranchGroup objRoot = new BranchGroup();

		TransformGroup objTrans = new TransformGroup();
		objRoot.addChild(objTrans);

		objTrans.setCapability( TransformGroup.ALLOW_TRANSFORM_READ );
		objTrans.setCapability( TransformGroup.ALLOW_TRANSFORM_WRITE );

	        MouseRotate rotat = new MouseRotate( objTrans );
	        MouseTranslate trans = new MouseTranslate( objTrans );
	        MouseZoom zoom = new MouseZoom( objTrans );

		BoundingSphere bounds = new BoundingSphere();
		bounds.setRadius( 10.0 );
	        rotat.setSchedulingBounds( bounds );
	        trans.setSchedulingBounds( bounds );
	        zoom.setSchedulingBounds( bounds );

		objTrans.addChild(rotat);
		objTrans.addChild(trans);
		objTrans.addChild(zoom);

		ColorCube colorCube = new ColorCube(0.5d);

		objTrans.addChild(colorCube);
                objRoot.compile();
                return objRoot;
        }

        public Sample3D() {
                getContentPane().setLayout(new BorderLayout());

                GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();

                Canvas3D canvas = new Canvas3D(config);
                getContentPane().add("Center", canvas);

                BranchGroup scene = createSceneGraph();
                SimpleUniverse universe = new SimpleUniverse(canvas);

                universe.getViewingPlatform().setNominalViewingTransform();

                universe.addBranchGraph(scene);
        }
        public static void main(String[] args) {
		Sample3D sample = new Sample3D();

		/* サイズ指定 */
		sample.setBounds( 10, 10, 240, 240);

                /* 終了処理を追加 */
                sample.addWindowListener(new WindowAdapter(){
                        public void windowClosing(WindowEvent e){System.exit(0);}
                });
                /* 実際に表示する */
                sample.setVisible(true);
        }
}

