import javax.swing.*;
import java.awt.event.*;
import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;
import com.sun.j3d.utils.universe.*;
import javax.media.j3d.*;
import com.sun.j3d.utils.geometry.Box;
import javax.vecmath.*;

public class Sample3D6 extends JFrame {
    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();

        objRoot.addChild(createLight());

        Appearance ap = new Appearance();
        Material ma = new Material();
        ma.setDiffuseColor(0.0f, 0.0f, 1.0f);
        ap.setMaterial(ma);

        Box box = new Box( 0.2f, 0.5f, 0.3f, ap);

        Transform3D t3dy = new Transform3D();
        t3dy.rotY(Math.PI / 6);
        Transform3D t3dx = new Transform3D();
        t3dx.rotX(Math.PI / 4);

        Transform3D t3d = new Transform3D();
        t3d.mul(t3dy, t3dx);

        TransformGroup objTrans = new TransformGroup(t3d);
        objRoot.addChild(objTrans);

        objTrans.addChild(box);
        objRoot.compile();

        return objRoot;
    }

    private Light createLight(){
        DirectionalLight light = new DirectionalLight( true,
                        new Color3f(0.0f, 0.0f, 1.0f),
                        new Vector3f(0.0f, 0.0f, -1.0f));

        light.setInfluencingBounds(new BoundingSphere(new Point3d(), 100.0));
  
        return light;
    }

    public Sample3D6() {
        getContentPane().setLayout(new BorderLayout());

        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();

        Canvas3D canvas = new Canvas3D(config);
        getContentPane().add(canvas, BorderLayout.CENTER);

        BranchGroup scene = createSceneGraph();
        SimpleUniverse universe = new SimpleUniverse(canvas);

        universe.getViewingPlatform().setNominalViewingTransform();
        universe.addBranchGraph(scene);
    }

    public static void main(String[] args) {
        Sample3D6 sample = new Sample3D6();

        sample.setBounds( 10, 10, 240, 240);
        sample.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        sample.setVisible(true);
    }
}
