import org.xml.sax.*;
import org.xml.sax.helpers.*;

class SampleHandler extends DefaultHandler{
    private int tab=0;
    private String currentTag;

    /* XML文書の開始時の処理*/
    public void startDocument(){
	System.out.println("Here is start of XML document.");
    }

    /* 要素の開始時の処理*/
    public void startElement(String namespaceURI,String localName,String qName,Attributes attrs){
	tabbing();
	System.out.println("Start Element");
	/* namespaceURIの表示 要調査*/
	if(namespaceURI!=""){
	    tabbing();
	    System.out.println("namespaceURI= "+namespaceURI);
	}
	/* localNameの表示 要調査*/
	if(localName!=""){
	    tabbing();
	    System.out.println("localName= "+localName);
	}
	/*タグ名を表示*/
	if(qName != ""){
	    tabbing();
	    System.out.println("qName= "+qName);
	    currentTag=qName;
	}
	/* 属性の表示*/
	/* 属性の数はAttributesのgetLength()で取得*/
	if(attrs.getLength()!=0){
	    tabbing();
	    /* 属性の値はAttributesのgetValue(int)で取得*/
	    System.out.println("attrs= "+attrs.getValue(0));
	    }
	tab++;
    }

    /*要素の終了時の処理*/
    public void endElement(String namespaceURI,String localName,String qName){
	tab--;	
	tabbing();
	System.out.println("End element.");
	if(namespaceURI!=""){
	    tabbing();
	    System.out.println("namespaceURI= "+namespaceURI);
	}
	if(localName!=""){
	    tabbing();
	    System.out.println("localName= "+localName);
	}

	if(qName!=""){
	    tabbing();
	    System.out.println("qName= "+qName);
	}
	currentTag="";
    }

    /* XML文書の終了時の処理*/
    public void endDocument(){
	System.out.println("Here is end of XML document.");
    }

    /* 文字列の処理*/
    public void characters(char[] ch,int start,int length){
	if(currentTag.equals("key")){
	    String str=new String(ch,start,length);
	    if(str.length()!=0){
		tab++;
		tabbing();
		tab--;
		System.out.println("====="+str+"=====");
	    }
	}
    }

    /* 処理命令を受けた時の処理 要調査*/
    public void processingInstruction(String target,String data){}

    /* プレフィックスによる名前空間の範囲の開始時 要調査*/
    public void startPrefixMapping(String prefix,String uri){}

    /* プレフィックスによる名前空間の範囲の終了時 要調査*/
    public void endPrefixMapping(String prefix){}

    /* インデント用.これはこのクラス独自のメソッド*/
    private void tabbing(){
	for(int i=0;i<tab;i++){
	    System.out.print("\t");
	}
    }
}
