import psxlinda

class FederatedLinda:
	def __init__(self):
		self.tuplespaces = []

	def open(self, hostname, port):
		tsid = psxlinda.open(hostname, port)
		if (tsid == -1):
			return None

		linda = Linda(tsid)
#		self.tuplespaces.append(linda)
		
		return linda
	
	def sync(self):
		psxlinda.sync()


# Reply from TupleSpace

class Reply:
	def __init__(self, seq):
		self.seq = seq

	def reply(self):
		return psxlinda.reply(self.seq)


# Linda class
TUPLE_ID_COUNT_CLIENT = 65535

class Linda:
	def __init__(self, tsid):
		self.tsid = tsid

	def In(self, tid):
		seq = psxlinda.In(self.tsid, tid)
		return Reply(seq)

	def Rd(self, tid):
		seq = psxlinda.Rd(self.tsid, tid)
		return Reply(seq)

	def Ck(self, tid):
		seq = psxlinda.Ck(self.tsid, tid)
		return Reply(seq)

	def WaitRd(self, tid):
		seq = psxlinda.WaitRd(self.tsid, tid)
		return Reply(seq)

	def Out(self, tid, data):
		psxlinda.Out(self.tsid, tid, data)

	def close(self):
		psxlinda.close(self.tsid)
		self.tsid = None

	def getid(self):
		rep = self.In(TUPLE_ID_COUNT_CLIENT)
		ret = None
		while (not ret):
			psxlinda.sync()
			ret = rep.reply()
		return ret

	def __del__(self):
		if self.tsid:
			self.close()

