import xml.dom.minidom

"""
<graph name = "Graf">
	<node label = "lindaA" tsid = "localhost:10001">
		<destination label = "lindaB"/>
	</node>
	<node label = "lindaB" tsid = "localhost:10000">
		<destination label = "lindaA"/>
	</node>
</graph>
"""
class NodeInfo:
    def __init__(self, tsid, label, dstlist):
        self.tsid = tsid
        self.label = label
        self.dstlist = dstlist

class LinkConfigParser:
    def getDest(self, childNodes):
        tmplist = []
        for n in childNodes:
            if n.nodeType == n.ELEMENT_NODE and n.localName == 'destination':
                tmplist.append(n.attributes['label'].nodeValue)
        return tmplist
    
    def parseLinkConfig(self, tsid, xmltxt):
        linkconf = xml.dom.minidom.parseString(xmltxt).childNodes[0]
        nodelist = linkconf.childNodes

        lc = LinkConfiguration(tsid)

        for n in nodelist:
            if n.nodeType == n.ELEMENT_NODE and n.localName == 'node':
                nattr = n.attributes
                nodelabel = nattr['label'].nodeValue
                nodetsid  = nattr['tsid'].nodeValue
                
                dstlist = self.getDest(n.childNodes)
                lc.linklist[nodelabel] = NodeInfo(nodetsid, nodelabel, dstlist)
                if nodetsid == lc.tsid:
                    lc.label = nodelabel

        return lc


class LinkConfiguration:
    def __init__(self, tsid):
        self.tsid = tsid
        self.label = None
        self.linklist = {}

    def getDstlist(self, label):
        if self.linklist.has_key(label):
            return self.linklist[label].dstlist
        else:
            return {}



if __name__ == '__main__':
    import sys
    if (len(sys.argv) != 2) :
        print "Usage : %s <hostname:portnum>" % sys.argv[0]
        sys.exit(1)

    
