import re
import sys
import string
import struct

sys.path.append('../modules')

import FederatedLinda
from CompactRouting import *

ROUTING_HEADER_FORMAT = "!I"
MAKER = "::::"

TUPLE_ID_LINKCONFIG = 1
TUPLE_ID_ROUTING = 2

ROUTING_COMMAND_CONNECT      =  1
ROUTING_COMMAND_DISCONNECT   =  2
ROUTING_COMMAND_TRANSFER     =  3
ROUTING_COMMAND_UPDATE_TABLE =  4

testxml = \
"""<graph name = "Graf">
  <node label = "A" tsid = "localhost:10000">
        <destination label = "B"/>
  </node>
  <node label = "B" tsid = "localhost:10001">
        <destination label = "C"/>
        <destination label = "D"/>
  </node>
  <node label = "C" tsid = "localhost:10002">
        <destination label = "D"/>
  </node>
  <node label = "D" tsid = "localhost:10003">
  </node>
</graph>
"""

def getFirstTsid(xmltext):
    p = re.compile('(?<=tsid = \").*(?=\")')
    m = p.findall(xmltext)
    return m[0]


    
if __name__ == "__main__":

    if (len(sys.argv) == 2):
        print " : %s <xmlfilename>" % sys.argv[0]
        xmltext = open(sys.argv[1]).read()
        if xmltext is None:
            sys.exit(1)
	
    else:
	xmltext = testxml
    #close else
    pass
    
    firsttsid = getFirstTsid(xmltext)    
    flinda = FederatedLinda.FederatedLinda()
    #first Landmark set
    landmark_tsidlist = firsttsid + ","
    #define dycstra hopcount
    landmark_hopcount = 2

    host, portnum = string.split(firsttsid,':')

    #set send packet format
    data = struct.pack(ROUTING_HEADER_FORMAT,landmark_hopcount)+landmark_tsidlist+MAKER+testxml
    linda1 = flinda.open(host, int(portnum))
    linda1.Out(TUPLE_ID_LINKCONFIG, data)

    #landmark_data = struct.pack(ROUTING_HEADER_FORMAT,landmark_hopcount,rt.landmark_tslist)
    #linda1.Out(TUPLE_ID_LANDMARKCONFIG, landmark_data)

    flinda.sync()



