import re
import sys
import string

sys.path.append('../modules')

import FederatedLindaJava

ROUTING_HEADER_FORMAT = "!I"
TUPLE_ID_LINKCONFIG = 1
TUPLE_ID_ROUTING = 2

ROUTING_COMMAND_CONNECT      =  1
ROUTING_COMMAND_DISCONNECT   =  2
ROUTING_COMMAND_TRANSFER     =  3
ROUTING_COMMAND_UPDATE_TABLE =  4

testxml = \
"""<graph name = "Graf">
	<node label = "Node005" tsid = "cls006.cs.ie.u-ryukyu.ac.jp:10006">
		<destination label = "Node003"/>
		<destination label = "Node004"/>
	</node>
	<node label = "Node004" tsid = "cls005.cs.ie.u-ryukyu.ac.jp:10005">
		<destination label = "Node001"/>
		<destination label = "Node002"/>
		<destination label = "Node005"/>
	</node>
	<node label = "Node003" tsid = "cls004.cs.ie.u-ryukyu.ac.jp:10004">
		<destination label = "Node005"/>
		<destination label = "Node002"/>
	</node>
	<node label = "Node002" tsid = "cls003.cs.ie.u-ryukyu.ac.jp:10003">
		<destination label = "Node000"/>
		<destination label = "Node003"/>
		<destination label = "Node004"/>
	</node>
	<node label = "Node001" tsid = "cls002.cs.ie.u-ryukyu.ac.jp:10002">
		<destination label = "Node004"/>
		<destination label = "Node000"/>
	</node>
	<node label = "Node000" tsid = "cls001.cs.ie.u-ryukyu.ac.jp:10001">
		<destination label = "Node002"/>
		<destination label = "Node001"/>
	</node>
</graph>
"""
def getFirstTsid(xmltext):
    p = re.compile('(?<=tsid = \").*(?=\")')
    m = p.findall(xmltext)
    return m[0]


    
if __name__ == "__main__":

    if (len(sys.argv) == 2):
        print " : %s <xmlfilename>" % sys.argv[0]
        xmltext = open(sys.argv[1]).read()
        if xmltext is None:
            sys.exit(1)
    else:
        xmltext = testxml
    
    firsttsid = getFirstTsid(xmltext)
    
    flinda = FederatedLindaJava.FederatedLinda()

    host, portnum = string.split(firsttsid,':')
    
    linda1 = flinda.open(host, int(portnum))
    linda1.Out(TUPLE_ID_LINKCONFIG, testxml)
    flinda.sync()
