import re
import sys
import string
import time

sys.path.append('../modules')

import FederatedLinda

ROUTING_HEADER_FORMAT = "!I"
TUPLE_ID_LINKCONFIG = 1
TUPLE_ID_ROUTING = 2

ROUTING_COMMAND_CONNECT      =  1
ROUTING_COMMAND_DISCONNECT   =  2
ROUTING_COMMAND_TRANSFER     =  3
ROUTING_COMMAND_UPDATE_TABLE =  4

testxml = \
"""
<graph name = "Graf">
	<node label = "Node023" tsid = "ant035.cs.ie.u-ryukyu.ac.jp:10023">
		<destination label = "Node017"/>
		<destination label = "Node029"/>
		<destination label = "Node022"/>
	</node>
	<node label = "Node022" tsid = "ant034.cs.ie.u-ryukyu.ac.jp:10022">
		<destination label = "Node016"/>
		<destination label = "Node021"/>
		<destination label = "Node023"/>
		<destination label = "Node028"/>
	</node>
	<node label = "Node021" tsid = "ant033.cs.ie.u-ryukyu.ac.jp:10021">
		<destination label = "Node015"/>
		<destination label = "Node020"/>
		<destination label = "Node022"/>
		<destination label = "Node027"/>
	</node>
	<node label = "Node020" tsid = "ant032.cs.ie.u-ryukyu.ac.jp:10020">
		<destination label = "Node014"/>
		<destination label = "Node019"/>
		<destination label = "Node021"/>
		<destination label = "Node026"/>
	</node>
	<node label = "Node019" tsid = "ant029.cs.ie.u-ryukyu.ac.jp:10019">
		<destination label = "Node013"/>
		<destination label = "Node018"/>
		<destination label = "Node020"/>
		<destination label = "Node025"/>
	</node>
	<node label = "Node018" tsid = "ant028.cs.ie.u-ryukyu.ac.jp:10018">
		<destination label = "Node012"/>
		<destination label = "Node019"/>
		<destination label = "Node024"/>
	</node>
	<node label = "Node017" tsid = "ant027.cs.ie.u-ryukyu.ac.jp:10017">
		<destination label = "Node023"/>
		<destination label = "Node011"/>
		<destination label = "Node016"/>
	</node>
	<node label = "Node016" tsid = "ant026.cs.ie.u-ryukyu.ac.jp:10016">
		<destination label = "Node022"/>
		<destination label = "Node015"/>
		<destination label = "Node017"/>
		<destination label = "Node010"/>
	</node>
	<node label = "Node015" tsid = "ant025.cs.ie.u-ryukyu.ac.jp:10015">
		<destination label = "Node021"/>
		<destination label = "Node014"/>
		<destination label = "Node016"/>
		<destination label = "Node009"/>
	</node>
	<node label = "Node014" tsid = "ant021.cs.ie.u-ryukyu.ac.jp:10014">
		<destination label = "Node020"/>
		<destination label = "Node013"/>
		<destination label = "Node015"/>
		<destination label = "Node008"/>
	</node>
	<node label = "Node013" tsid = "ant020.cs.ie.u-ryukyu.ac.jp:10013">
		<destination label = "Node019"/>
		<destination label = "Node012"/>
		<destination label = "Node014"/>
		<destination label = "Node007"/>
	</node>
	<node label = "Node012" tsid = "ant019.cs.ie.u-ryukyu.ac.jp:10012">
		<destination label = "Node018"/>
		<destination label = "Node013"/>
	</node>
	<node label = "Node011" tsid = "ant018.cs.ie.u-ryukyu.ac.jp:10011">
		<destination label = "Node006"/>
		<destination label = "Node017"/>
		<destination label = "Node010"/>
	</node>
	<node label = "Node010" tsid = "ant017.cs.ie.u-ryukyu.ac.jp:10010">
		<destination label = "Node005"/>
		<destination label = "Node009"/>
		<destination label = "Node011"/>
		<destination label = "Node016"/>
	</node>
	<node label = "Node009" tsid = "ant015.cs.ie.u-ryukyu.ac.jp:10009">
		<destination label = "Node004"/>
		<destination label = "Node008"/>
		<destination label = "Node010"/>
		<destination label = "Node015"/>
	</node>
	<node label = "Node008" tsid = "ant014.cs.ie.u-ryukyu.ac.jp:10008">
		<destination label = "Node003"/>
		<destination label = "Node007"/>
		<destination label = "Node009"/>
		<destination label = "Node014"/>
	</node>
	<node label = "Node007" tsid = "ant013.cs.ie.u-ryukyu.ac.jp:10007">
		<destination label = "Node008"/>
		<destination label = "Node013"/>
	</node>
	<node label = "Node006" tsid = "ant012.cs.ie.u-ryukyu.ac.jp:10006">
		<destination label = "Node011"/>
		<destination label = "Node002"/>
		<destination label = "Node005"/>
	</node>
	<node label = "Node005" tsid = "ant011.cs.ie.u-ryukyu.ac.jp:10005">
		<destination label = "Node010"/>
		<destination label = "Node004"/>
		<destination label = "Node006"/>
		<destination label = "Node001"/>
	</node>
	<node label = "Node004" tsid = "ant005.cs.ie.u-ryukyu.ac.jp:10004">
		<destination label = "Node009"/>
		<destination label = "Node003"/>
		<destination label = "Node005"/>
		<destination label = "Node000"/>
	</node>
	<node label = "Node003" tsid = "ant004.cs.ie.u-ryukyu.ac.jp:10003">
		<destination label = "Node008"/>
		<destination label = "Node004"/>
	</node>
	<node label = "Node002" tsid = "ant003.cs.ie.u-ryukyu.ac.jp:10002">
		<destination label = "Node006"/>
		<destination label = "Node001"/>
	</node>
	<node label = "Node001" tsid = "ant002.cs.ie.u-ryukyu.ac.jp:10001">
		<destination label = "Node000"/>
		<destination label = "Node002"/>
		<destination label = "Node005"/>
	</node>
	<node label = "Node000" tsid = "ant001.cs.ie.u-ryukyu.ac.jp:10000">
		<destination label = "Node001"/>
		<destination label = "Node004"/>
	</node>
	<node label = "Node029" tsid = "ant041.cs.ie.u-ryukyu.ac.jp:10029">
		<destination label = "Node023"/>
		<destination label = "Node028"/>
	</node>
	<node label = "Node028" tsid = "ant040.cs.ie.u-ryukyu.ac.jp:10028">
		<destination label = "Node027"/>
		<destination label = "Node029"/>
		<destination label = "Node022"/>
	</node>
	<node label = "Node027" tsid = "ant039.cs.ie.u-ryukyu.ac.jp:10027">
		<destination label = "Node026"/>
		<destination label = "Node028"/>
		<destination label = "Node021"/>
	</node>
	<node label = "Node026" tsid = "ant038.cs.ie.u-ryukyu.ac.jp:10026">
		<destination label = "Node025"/>
		<destination label = "Node027"/>
		<destination label = "Node020"/>
	</node>
	<node label = "Node025" tsid = "ant037.cs.ie.u-ryukyu.ac.jp:10025">
		<destination label = "Node024"/>
		<destination label = "Node026"/>
		<destination label = "Node019"/>
	</node>
	<node label = "Node024" tsid = "ant036.cs.ie.u-ryukyu.ac.jp:10024">
		<destination label = "Node025"/>
		<destination label = "Node018"/>
	</node>
</graph>
"""
def getFirstTsid(xmltext):
    p = re.compile('(?<=tsid = \").*(?=\")')
    m = p.findall(xmltext)
    return m[0]


    
if __name__ == "__main__":

    if (len(sys.argv) == 2):
        print " : %s <xmlfilename>" % sys.argv[0]
        xmltext = open(sys.argv[1]).read()
        if xmltext is None:
            sys.exit(1)
    else:
        xmltext = testxml

    start = time.time()
    print "start time ",start 
    
    firsttsid = getFirstTsid(xmltext)
    
    flinda = FederatedLinda.FederatedLinda()

    host, portnum = string.split(firsttsid,':')
    
    linda1 = flinda.open(host, int(portnum))
    linda1.Out(TUPLE_ID_LINKCONFIG, testxml)
    flinda.sync()



