import re
import sys
import string
import time

sys.path.append('../modules')

import FederatedLinda

ROUTING_HEADER_FORMAT = "!I"
TUPLE_ID_LINKCONFIG = 1
TUPLE_ID_ROUTING = 2

ROUTING_COMMAND_CONNECT      =  1
ROUTING_COMMAND_DISCONNECT   =  2
ROUTING_COMMAND_TRANSFER     =  3
ROUTING_COMMAND_UPDATE_TABLE =  4

testxml = \
"""<graph name = "Graf">
	<node label = "Node009" tsid = "localhost:10009">
		<destination label = "Node008"/>
	</node>
	<node label = "Node008" tsid = "localhost:10008">
		<destination label = "Node009"/>
		<destination label = "Node007"/>
	</node>
	<node label = "Node007" tsid = "localhost:10007">
		<destination label = "Node008"/>
		<destination label = "Node006"/>
	</node>
	<node label = "Node006" tsid = "localhost:10006">
		<destination label = "Node007"/>
		<destination label = "Node000"/>
	</node>
	<node label = "Node005" tsid = "localhost:10005">
		<destination label = "Node004"/>
	</node>
	<node label = "Node004" tsid = "localhost:10004">
		<destination label = "Node003"/>
		<destination label = "Node005"/>
	</node>
	<node label = "Node003" tsid = "localhost:10003">
		<destination label = "Node002"/>
		<destination label = "Node004"/>
	</node>
	<node label = "Node002" tsid = "localhost:10002">
		<destination label = "Node001"/>
		<destination label = "Node003"/>
	</node>
	<node label = "Node001" tsid = "localhost:10001">
		<destination label = "Node000"/>
		<destination label = "Node002"/>
	</node>
	<node label = "Node000" tsid = "localhost:10000">
		<destination label = "Node006"/>
		<destination label = "Node001"/>
	</node>
</graph>
"""
def getFirstTsid(xmltext):
    p = re.compile('(?<=tsid = \").*(?=\")')
    m = p.findall(xmltext)
    return m[0]


    
if __name__ == "__main__":

    if (len(sys.argv) == 2):
        print " : %s <xmlfilename>" % sys.argv[0]
        xmltext = open(sys.argv[1]).read()
        if xmltext is None:
            sys.exit(1)
    else:
        xmltext = testxml

    start = time.time()
    print "start time ",start 
    
    firsttsid = getFirstTsid(xmltext)
    
    flinda = FederatedLinda.FederatedLinda()

    host, portnum = string.split(firsttsid,':')
    
    linda1 = flinda.open(host, int(portnum))
    linda1.Out(TUPLE_ID_LINKCONFIG, testxml)
    flinda.sync()



