import string
import struct

import xml.dom.minidom

testxml = \
"""<graph name = "Graf">

  <node label = "A" tsid = "localhost:10000">
        <destination label = "B"/>
  </node>

  <node label = "B" tsid = "localhost:10001">
        <destination label = "A"/>
  </node>

  <landmark hopnum = "3">
        <destination label = "B"/>
  </landmark>
</graph>
"""

def getText(elm):
    nodelist = elm.childNodes
    rc = ""
    for node in nodelist:
        if node.nodeType == node.TEXT_NODE:
            rc = rc + node.data

    return rc

def getlandmark_hopcount():
    rt = xml.dom.minidom.parseString(testxml).childNodes[0]
    landmark = rt.getElementsByTagName('landmark')[0]
    hop = landmark.getAttribute('hopnum')
    return hop

if __name__ == '__main__':

    rt = getlandmark_hopcount()
    print rt
