#!/usr/bin/python -W all

import string
import struct

import FederatedLinda

TUPLE_ID_ROUTING    = 2
TUPLE_ID_RECV = 3

ROUTING_COMMAND_CONNECT      =  1
ROUTING_COMMAND_DISCONNECT   =  2
ROUTING_COMMAND_TRANSFER     =  3
ROUTING_COMMAND_UPDATE_TABLE =  4

class RoutingClient:
    def __init__(self, routingTID = TUPLE_ID_ROUTING, transTID = TUPLE_ID_RECV):
        self.flinda = FederatedLinda.FederatedLinda()
        self.linda = None

        self.tsid = None
        self.neighbors = {}

        self.routingTID = routingTID

        self.transTID = transTID
        self.transReply = None

    def __del__(self):
        self.linda.close()
        for l in self.neighbors.values():
            l.close()        

    def connect(self, tsid):
        host, port = string.split(tsid, ':', 1)
        linda = self.flinda.open(self, tsid, host, port)
        if linda:
            linda.getid()
            return self.addNeighbor(tsid, linda)

        return None

    def addNeighbor(self, tsid, linda):
        if linda:
            self.neighbors[tsid] = linda

        return linda

    def pack(self, dsttsid, data):
        routing_packet = dsttsid + "," +  str(self.transTID) + "," + self.tsid + "," + data
        packet = struct.pack("!I", ROUTING_COMMAND_TRANSFER) + routing_packet
        return packet

    def unpack(self, packed):
#        r = struct.unpack("!I" + str(len(packed)-struct.calcsize("!I")) + "s", packed)
        return string.split(packed, ',', 3)

    def run(self, mytsid):
        self.tsid = mytsid
        hostname, port = string.split(self.tsid, ':', 1)
        self.linda = self.flinda.open(hostname, int(port))
        if not self.linda:
            return
        
        self.linda.getid() # get client id from Tuple Space (ldserv)

        self.transReply = self.linda.In(self.transTID)
        self.flinda.sync()

        while (1):
            try:
                # get reply 
                rep = self.transReply.reply()
                if (rep):
                    dsttsid, dsttid, srctsid, data = self.unpack(rep)
                    print "from %s : %s" % (srctsid, data)
                    self.transReply = self.linda.In(self.transTID)
                
                # input is as "DstTSID,DATA"
                inputed = raw_input(">> ")
                if inputed != "":
                    t = string.split(inputed, ',', 1)
                    self.linda.Out(self.routingTID, self.pack(t[0], t[1]))

            except struct.error:
                print "Invalid arguments of header :", t

            except EOFError:
                break

            else:
                self.flinda.sync()

if __name__ == '__main__':
    import sys
    if (len(sys.argv) < 2) :
        print "Usage : %s <hostname:portnum>" % sys.argv[0]
        sys.exit(1)

    mytsid = sys.argv[1]

    routing_client = RoutingClient()
    routing_client.run(mytsid)

