import re
import sys
import string

sys.path.append('../modules')

import FederatedLinda

ROUTING_HEADER_FORMAT = "!I"
TUPLE_ID_LINKCONFIG = 1
TUPLE_ID_ROUTING = 2

ROUTING_COMMAND_CONNECT      =  1
ROUTING_COMMAND_DISCONNECT   =  2
ROUTING_COMMAND_TRANSFER     =  3
ROUTING_COMMAND_UPDATE_TABLE =  4

testxml = \
"""<graph name = "Graf">
  <node label = "A" tsid = "localhost:10000">
        <destination label = "B"/>
  </node>
  <node label = "B" tsid = "localhost:10001">
        <destination label = "C"/>
        <destination label = "D"/>
  </node>
  <node label = "C" tsid = "localhost:10002">
        <destination label = "D"/>
  </node>
  <node label = "D" tsid = "localhost:10003">
        <destination label = "A"/>
  </node>
</graph>
"""
def getFirstTsid(xmltext):
    p = re.compile('(?<=tsid = \").*(?=\")')
    m = p.findall(xmltext)
    return m[0]


    
if __name__ == "__main__":

    if (len(sys.argv) == 2):
        print " : %s <xmlfilename>" % sys.argv[0]
        xmltext = open(sys.argv[1]).read()
        if xmltext is None:
            sys.exit(1)
    else:
        xmltext = testxml
    
    firsttsid = getFirstTsid(xmltext)
    
    flinda = FederatedLinda.FederatedLinda()

    host, portnum = string.split(firsttsid,':')
    
    linda1 = flinda.open(host, int(portnum))
    linda1.Out(TUPLE_ID_LINKCONFIG, testxml)
    flinda.sync()



