import re
import sys
import xml.sax

import PListReader

def parseFile(filep = "example.graffle"):
    # parse the file
    reader = PListReader.PListReader()
    parser = xml.sax.make_parser()
    for key, value in reader.getRecommendedFeatures().items():
        parser.setFeature(key, value)
    parser.setContentHandler(reader)
    parser.parse(open(filep, 'r'))
    return reader.getResult()

def getText(text):
    parser = re.compile("(?<=\cf0 ).*(?=})")
    return parser.search(text, re.I).group(0)

class NodeInfo:
    def __init__(self, label = "", nid = None, tsid = None):
        self.dstlist = []
        self.label = label
        self.id = nid
        self.tsid = tsid

def parsedlist2dotfile (parsedlist, nodelist):
    nodes = {}
    edges = {}
    i = 0
    dotfile = """graph Graf {\n"""
    txtlist = [dotfile]
    for g in parsedlist["GraphicsList"]:
        cls = g['Class']
        if cls == "LineGraphic":
            if g.has_key('Lables'):
                label = getText(g['Labels'][0]['Label']['Text'])
            else:
                label = "Edge" + str(g['ID'])
            txtlist.append('\t%s -- %s;\n'%(g['Head']['ID'],g['Tail']['ID']))
        elif cls == "ShapedGraphic":
            if g.has_key('Text'):
                label = getText(g['Text']['Text'])
            else:
                label = "Node" + "%03d"%i  #str(g['ID'])
                i += 1
            txtlist.append('\t%s[label = "%s"];\n'%(g['ID'],nodelist.pop(0)))
        else:
            print "ID >>", g['ID']

    txtlist.append("}")
    return "".join(txtlist)



if __name__ == "__main__":

    if (len(sys.argv) > 2):
        xmltext = sys.argv[1]
    else:
        xmltext = "example.graffle"

    nodetxt = open(sys.argv[2],'r').read()
    nodelist = re.findall("[-.\w]+:[0-9]+",nodetxt)
    
    res = parseFile(xmltext)
    testdot = parsedlist2dotfile(res, nodelist)
    print testdot


