import re
import sys

import ParseGraffle

def parsedlist2dotfile (parsedlist, nodelist):
    nodes, edges = ParseGraffle.getNodesEdges(parsedlist, nodelist)

    %print "nodes:"
    %print nodes
    %print "edges:"
    %print edges

    dotfile = """graph Graf {\n"""
    txtlist = [dotfile]
    for n in nodes.values():
        txtlist.append('\t%s[label = "%s"];\n' % (n.label, n.tsid))
        if edges.has_key(n.id):
            destlist = edges[n.id]
            for e in destlist:
                txtlist.append('\t%s -- %s;\n' % (n.label, nodes[e].label))

    txtlist.append("}")
    return "".join(txtlist)

def usage(progname):
    print "Usage : %s <graffle_file> <nodelist>" % progname
    sys.exit(1)


if __name__ == "__main__":

    if len(sys.argv) < 3:
        usage(sys.argv[0])

    grafflefile = sys.argv[1]

    nodetxt = open(sys.argv[2],'r').read()
    nodelist = re.findall("[-.\w]+:[0-9]+",nodetxt)
    
    res = ParseGraffle.parseFile(grafflefile)
    
    testdot = parsedlist2dotfile(res, nodelist)
    print testdot


