import re
import sys
import xml.sax

import PListReader
import ParseGraffle

testxml = \
"""<graph name = "Graf">
  <node label = "A" tsid = "localhost:10000">
        <destination label = "B"/>
  </node>
  <node label = "B" tsid = "localhost:10001">
        <destination label = "C"/>
        <destination label = "D"/>
  </node>
  <node label = "C" tsid = "localhost:10002">
        <destination label = "D"/>
  </node>
  <node label = "D" tsid = "localhost:10003">
        <destination label = "A"/>
  </node>
</graph>
"""
def parsedlist2lcxml (parsedlist, nodelist):
    nodes, edges = ParseGraffle.getNodesEdges(parsedlist, nodelist)
    
    lcxml = """<graph name = "Graf">\n"""
    txtlist = [lcxml]
    for n in nodes.values():
        txtlist.append('\t<node label = "%s" tsid = "%s">\n' % (n.label, n.tsid))
        if edges.has_key(n.id):
            destlist = edges[n.id]
            for e in destlist:
                txtlist.append('\t\t<destination label = "%s"/>\n' % nodes[e].label)

        txtlist.append('\t</node>\n')

    txtlist.append("</graph>")
    return "".join(txtlist)



if __name__ == "__main__":

    if (len(sys.argv) > 2):
        grafflefile = sys.argv[1]
    else:
        grafflefile = "example.graffle"

    nodetxt = open(sys.argv[2],'r').read()
    nodelist = re.findall("[-.\w]+:[0-9]+",nodetxt)
    
    res = ParseGraffle.parseFile(grafflefile)
    testxml = parsedlist2lcxml(res, nodelist)
    print testxml


