import re
import sys
import string
import xml.sax

import PListReader

sys.path.append('../modules')

import FederatedLinda

ROUTING_HEADER_FORMAT = "!I"
TUPLE_ID_LINKCONFIG = 1

testxml = \
"""<graph name = "Graf">
  <node label = "A" tsid = "localhost:10000">
        <destination label = "B"/>
  </node>
  <node label = "B" tsid = "localhost:10001">
        <destination label = "C"/>
        <destination label = "D"/>
  </node>
  <node label = "C" tsid = "localhost:10002">
        <destination label = "D"/>
  </node>
  <node label = "D" tsid = "localhost:10003">
        <destination label = "A"/>
  </node>
</graph>
"""
def getFirstTsid(xmltext):
    p = re.compile('(?<=tsid = \").*(?=\")')
    m = p.findall(xmltext)
    return m[0]


def parseFile(filep = "example.graffle"):
    # parse the file
    reader = PListReader.PListReader()
    parser = xml.sax.make_parser()
    for key, value in reader.getRecommendedFeatures().items():
        parser.setFeature(key, value)
    parser.setContentHandler(reader)
    parser.parse(open(filep, 'r'))
    return reader.getResult()

def getText(text):
    parser = re.compile("(?<=\cf0 ).*(?=})")
    return parser.search(text, re.I).group(0)

class NodeInfo:
    def __init__(self, label = "", nid = None, tsid = None):
        self.dstlist = []
        self.label = label
        self.id = nid
        self.tsid = tsid

def parsedlist2lcxml (parsedlist, nodelist):
    nodes = {}
    edges = {}
    i = 0

    for g in parsedlist["GraphicsList"]:
        cls = g['Class']
        if cls == "LineGraphic":
            if g.has_key('Lables'):
                label = getText(g['Labels'][0]['Label']['Text'])
            else:
                label = "Edge" + str(g['ID'])
            if edges.has_key(g['Head']['ID']):
                edges[g['Head']['ID']].append(g['Tail']['ID'])
            else:
                edges[g['Head']['ID']] = [(g['Tail']['ID'])]
            if edges.has_key(g['Tail']['ID']):
                edges[g['Tail']['ID']].append(g['Head']['ID'])
            else:
                edges[g['Tail']['ID']] = [(g['Head']['ID'])]
        elif cls == "ShapedGraphic":
            if g.has_key('Text'):
                label = getText(g['Text']['Text'])
            else:
                label = "Node" + str(g['ID'])
            nodes[g['ID']] = NodeInfo(label, g['ID'], nodelist[i])
            i += 1
        else:
            print "ID >>", g['ID']

    lcxml = """<graph name = "Graf">\n"""
    txtlist = [lcxml]
    for n in nodes.values():
        txtlist.append('\t<node label = "%s" tsid = "%s">\n' % (n.label, n.tsid))
        if edges.has_key(n.id):
            destlist = edges[n.id]
            for e in destlist:
                txtlist.append('\t\t<destination label = "%s"/>\n' % nodes[e].label)

        txtlist.append('\t</node>\n')

    txtlist.append("</graph>")
    # return node number and nodesxml
    return len(nodes.values()),"".join(txtlist)

def usage(progname):
    print "Usage : %s <graffle_file> <nodelist>" % progname
    sys.exit(1)

if __name__ == "__main__":

    if (len(sys.argv) < 2):
        usage(sys.argv[0])

    xmltext = sys.argv[1]

    nodetxt = open(sys.argv[2],'r').read()
    nodelist = re.findall("[-.\w]+:[0-9]+",nodetxt)
    firstnode = nodelist[0]

    res = parseFile(xmltext)
    nodenum, testxml = parsedlist2lcxml(res, nodelist)
    print nodenum, testxml
    flinda = FederatedLinda.FederatedLinda()
    lindalist = []
    for i in range(0,nodenum):
        host, portnum = string.split(nodelist[i],':')
        linda = flinda.open(host, int(portnum))
        linda.Out(TUPLE_ID_LINKCONFIG, testxml)
        lindalist.append(linda)

    flinda.sync()
    print lindalist

