import re
import sys
import xml.sax

import PListReader

def parseFile(filep):
    # parse the file
    reader = PListReader.PListReader()
    parser = xml.sax.make_parser()
    for key, value in reader.getRecommendedFeatures().items():
        parser.setFeature(key, value)
    parser.setContentHandler(reader)
    parser.parse(open(filep, 'r'))
    return reader.getResult()

def getText(text):
    parser = re.compile("(?<=\cf0 ).*(?=})")
    return parser.search(text, re.I).group(0)

class NodeInfo:
    def __init__(self, label = "", nid = None, tsid = None):
        self.dstlist = []
        self.label = label
        self.id = nid
        self.tsid = tsid

def getNodesEdges (parsedlist, nodelist = []):
    nodes = {}
    edges = {}
    i = 0
    for g in parsedlist["GraphicsList"]:
        cls = g['Class']
        if cls == "LineGraphic":
            if g.has_key('Lables'):
                label = getText(g['Labels'][0]['Label']['Text'])
            else:
                label = "Edge" + str(g['ID'])
            if edges.has_key(g['Head']['ID']):
                edges[g['Head']['ID']].append(g['Tail']['ID'])
            else:
                edges[g['Head']['ID']] = [(g['Tail']['ID'])]
            if edges.has_key(g['Tail']['ID']):
                edges[g['Tail']['ID']].append(g['Head']['ID'])
            else:
                edges[g['Tail']['ID']] = [(g['Head']['ID'])]
        elif cls == "ShapedGraphic":
            if g.has_key('Text'):
                label = getText(g['Text']['Text'])
            else:
                label = "Node" + "%03d"%i  #str(g['ID'])
                i += 1
            if len(nodelist) == 0:
                ntsid = "localhost:%d" % i + 10000
                print "Cannot get tsid from nodelist, Added", ntsid
            else:
                ntsid = nodelist.pop(0)
            nodes[g['ID']] = NodeInfo(label, g['ID'], ntsid)
        else:
            print "ID >>", g['ID']

    return (nodes, edges)

def getNodesEdgesPositions (parsedlist, nodelist = []):
    nodes = {}
    edges = {}
    Positions = {}

    i = 0
    for g in parsedlist["GraphicsList"]:
        cls = g['Class']
        if cls == "LineGraphic":
            if g.has_key('Lables'):
                label = getText(g['Labels'][0]['Label']['Text'])
            else:
                label = "Edge" + str(g['ID'])
            if edges.has_key(g['Head']['ID']):
                edges[g['Head']['ID']].append(g['Tail']['ID'])
            else:
                edges[g['Head']['ID']] = [(g['Tail']['ID'])]
            if edges.has_key(g['Tail']['ID']):
                edges[g['Tail']['ID']].append(g['Head']['ID'])
            else:
                edges[g['Tail']['ID']] = [(g['Head']['ID'])]
        elif cls == "ShapedGraphic":
            if g.has_key('Text'):
                label = getText(g['Text']['Text'])
            else:
                label = "Node" + "%03d"%i  #str(g['ID'])
                i += 1
            if len(nodelist) == 0:
                ntsid = "localhost:%d" % i + 10000
                print "Cannot get tsid from nodelist, Added", ntsid
            else:
                ntsid = nodelist.pop(0)
            nodes[g['ID']] = NodeInfo(label, g['ID'], ntsid)
        else:
            print "ID >>", g['ID']

    return (nodes, edges)

if __name__ == "__main__":

    if (len(sys.argv) > 2):
        xmltext = sys.argv[1]
    else:
        xmltext = "example.graffle"

    nodetxt = open(sys.argv[2],'r').read()
    nodelist = re.findall("[-.\w]+:[0-9]+",nodetxt)
    res = parseFile(xmltext)

    nodes,edges  = getNodesEdges(res, nodelist)
    print nodes, edges


