#include <Python.h>
#include "lindaapi.h"


static PyObject *
psxlinda_ld(PyObject *args, char cmd) {
    int seq;
    unsigned int tspace_id;
    unsigned int id;

    if (!PyArg_ParseTuple(args, "ii", &tspace_id, &id)) {
        return NULL;
    }

    seq = psx_ld(tspace_id, id, cmd, NULL, NULL);

    return (Py_BuildValue("i", seq));
}


static PyObject *
psxlinda_in(PyObject *self, PyObject *args) {
    return psxlinda_ld(args, 'i');
}


static PyObject *
psxlinda_rd(PyObject *self, PyObject *args) {
    return psxlinda_ld(args, 'r');
}


static PyObject *
psxlinda_ck(PyObject *self, PyObject *args) {
    return psxlinda_ld(args, 'c');
}


static PyObject *
psxlinda_wait_rd(PyObject *self, PyObject *args) {
    return psxlinda_ld(args, 'w');
}


static PyObject *
psxlinda_out(PyObject *self, PyObject *args) {
    unsigned int tspace_id;
    unsigned int id;
    unsigned char *data;
    unsigned int size;

    if (!PyArg_ParseTuple(args, "iis#", &tspace_id, &id, &data, &size)) {
        return NULL;
    }

    psx_out(tspace_id, id, data, size);

    return (Py_BuildValue(""));
}


static PyObject *
psxlinda_reply(PyObject *self, PyObject *args) {
    PyObject *retval;
    unsigned char *p;
    unsigned int len;
    unsigned int seq;

    if (!PyArg_ParseTuple(args, "i", &seq)) {
        return NULL;
    }

    if ((p = psx_reply(seq))) {
        len = psx_get_datalength(p);
        retval = Py_BuildValue("s#", psx_get_data(p), len);// copied
        //printf("%p\n", p);
        psx_free(p); // must psx_free returned value
    } else {
        retval = Py_BuildValue("");
    }

    return retval;
}

static PyObject *
psxlinda_sync(PyObject *self, PyObject *args) {
    psx_sync_n();
    return (Py_BuildValue(""));
}


static PyObject *
psxlinda_open(PyObject *self, PyObject *args) {
    int tsid;
    char *hostname;
    int port;

    if (!PyArg_ParseTuple(args, "si", &hostname, &port)) {
        return NULL;
    }

    tsid = open_linda(hostname, port);
    
    return Py_BuildValue("i", tsid);
}

static PyObject *
psxlinda_open_java(PyObject *self, PyObject *args) {
    int tsid;
    char *hostname;
    int port;

    if (!PyArg_ParseTuple(args, "si", &hostname, &port)) {
        return NULL;
    }

    tsid = open_linda_java(hostname, port);
    
    return Py_BuildValue("i", tsid);
}


static PyObject *
psxlinda_close(PyObject *self, PyObject *args) {
    int tsid;
    int retval;
    
    if (!PyArg_ParseTuple(args, "i", &tsid)) {
        return NULL;
    }

    retval = close_linda(tsid);

    return Py_BuildValue("i", retval);
}


static PyMethodDef PSXLindaMethods[] = {
    {"In", psxlinda_in, METH_VARARGS, "Queue a IN command."},
    {"Rd", psxlinda_rd, METH_VARARGS, "Queue a READ command."},
    {"Ck", psxlinda_ck, METH_VARARGS, "Queue a CHECK command."},
    {"WaitRd", psxlinda_wait_rd, METH_VARARGS, "Queue a WAIT_READ command."},
    {"Out", psxlinda_out, METH_VARARGS, "Queue a OUT command."},
    {"reply", psxlinda_reply, METH_VARARGS, "Get a Reply Data."},
    {"sync", psxlinda_sync, METH_VARARGS, "Send and Receive Queued commands"},
    {"open", psxlinda_open, METH_VARARGS, "Open a connection to TupleSpace."},
    {"open_java", psxlinda_open_java, METH_VARARGS, "Open a connection to TupleSpace, For Java."},
    {"close", psxlinda_close, METH_VARARGS, "Close a connection to TupleSpace."},
    {"reply", psxlinda_reply, METH_VARARGS, "Get a Reply Data."},
    {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC
initpsxlinda(void)
{
    (void) Py_InitModule("psxlinda", PSXLindaMethods);
}
