﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace FeedGenerator.lib
{
    class Feed
    {
        public FeedInfo feedinfo;
        public List<Entry> entryList;

        private string xmlPath;
        public bool isInsertBrTag;

        public Feed(bool isInsertBrTag)
        {
            xmlPath = string.Empty;
            feedinfo = new FeedInfo();
            entryList = new List<Entry>();
            this.isInsertBrTag = isInsertBrTag;
        }

        /// <summary>
        /// インスタンスを生成し、指定されたパスからXMLを読み込みんで解析し、結果をfeedinfo変数及びentryList変数に格納します。
        /// </summary>
        /// <param name="xmlPath">読み込むXMLのパス</param>
        public Feed(string xmlPath, bool isInsertBrTag)
        {
            this.xmlPath = xmlPath;
            feedinfo = new FeedInfo();
            this.isInsertBrTag = isInsertBrTag;

            readXml(isInsertBrTag);
        }

        /// <summary>
        /// XMLファイルを読み込んで解析し、結果をfeedinfo変数及びentryList変数に格納します。
        /// </summary>
        private void readXml(bool isInsertBrTag) 
        {
            feedinfo.readXml(xmlPath);
            entryList = Entry.readXml(xmlPath, isInsertBrTag);
            this.isInsertBrTag = isInsertBrTag;
        }

        /// <summary>
        /// インスタンスを生成した際に指定したパスにfeedinfo変数及びentryList変数の内容を格納します。
        /// </summary>
        public void writeXml()
        {
            if (xmlPath == string.Empty)
                throw new FileNotFoundException("Paramater xmlPath is blank.");

            // 指定されたパスに内容を書き込む
            this.writeXml(xmlPath);

            // fileinfo及びentryList変数の内容を更新する
            readXml(isInsertBrTag);
        }

        /// <summary>
        /// 指定されたパスにfeedinfo変数及びentryList変数の内容を格納します。
        /// </summary>
        /// <param name="writePath">書き込みファイルのパス</param>
        public void writeXml(string writePath)
        {
            StringBuilder buffer = new StringBuilder();

            // ヘッダ部分
            buffer.AppendLine("<?xml version=\"1.0\" encoding=\"utf-8\"?>");

            // XML基本設定部分
            buffer.AppendLine(feedinfo.ToString());

            // ENTRY部分
            foreach (Entry entry in entryList)
            {
                buffer.AppendLine(entry.ToString());
            }

            // フッタ部分
            buffer.AppendLine("</feed>");

            // ファイルへの書き込みを行う
            StreamWriter writer = new StreamWriter(writePath, false, Encoding.UTF8);
            writer.Write(buffer.ToString());
            writer.Close();
        }
    }
}
