﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;

namespace FeedGenerator.lib
{
    public class RFC3339
    {
        /// <summary>
        /// 与えられたDateTimeのRFC3339形式の日本時間を返します
        /// </summary>
        /// <param name="dateTime">RFC3339形式にしたいDateTimeオブジェクト</param>
        /// <returns>文字列に変換されたDateTimeオブジェクト</returns>
        public static string getTime(DateTime dateTime)
        {
            return dateTime.ToString("s") + "+09:00";
        }

        /// <summary>
        /// RFC3339形式の文字列を読み込み、DateTimeに変換するメソッド
        /// </summary>
        /// <param name="rfc3339">RFC3339形式の文字列</param>
        /// <returns>文字列から変換されたDateTime型</returns>
        public static DateTime getDateTime(string rfc3339)
        {
            Hashtable dateTable = new Hashtable();
            DateTime returnTime = DateTime.Now;
            try
            {
                dateTable["year"] = int.Parse(rfc3339.Substring(0, 4));
                dateTable["month"] = int.Parse(rfc3339.Substring(5, 2));
                dateTable["day"] = int.Parse(rfc3339.Substring(8, 2));
                dateTable["hour"] = int.Parse(rfc3339.Substring(11, 2));
                dateTable["minute"] = int.Parse(rfc3339.Substring(14, 2));
                dateTable["second"] = int.Parse(rfc3339.Substring(17, 2));
                return new DateTime((int)dateTable["year"], (int)dateTable["month"], (int)dateTable["day"], (int)dateTable["hour"], (int)dateTable["minute"], (int)dateTable["second"]);
            }
            catch (Exception)
            {
                throw new FormatException();
            }
        }
    }
}
