unit u_Marker;

{
  Feeding Origin 2 is software that supports calculation of nutrient requirement of livestock
  and feed design based on Japanese feeding standard.
  Copyright (C) 2017,  Syuichiro Fukagawa.

  This program is free software; you can redistribute it and/or modify it under the terms of
  the GNU General Public License as published by the Free Software Foundation; either version 3
  of the License, or (at your option) any later version.
  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  You should have received a copy of the GNU General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.


  Feeding Origin 2は、日本飼養標準に基づいた家畜の養分要求量の計算および飼料設計を支援するソフ
  トウェアです.
  Copyright (C) 2017,　深川修一郎.

  　このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア財団によって
  発行されたGNU一般公衆利用許諾書(バージョン3か、それ以降のバージョンのうちどれか)が定める
  条件の下で再頒布または改変することができます。
  このプログラムは有用であることを願って頒布されますが、*全くの無保証* です。商業可能性の保証
  や特定目的への適合性は、言外に示されたものも含め、全く存在しません。詳しくはGNU一般公衆利用
  許諾書をご覧ください。
  　あなたはこのプログラムと共に、GNU一般公衆利用許諾書のコピーを一部 受け取っているはずです。
  もし受け取っていなければ、<http://www.gnu.org/licenses/> をご覧ください。
  
  *本日本語訳は、FSFより2007年6月29日に発行されたGNU GPL v3の原文から、八田真行氏が翻訳した
   ものを基にしています。 ＜ https://mag.osdn.jp/07/09/02/130237 ＞
}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls;

type

  { TfMarker }
  iMarkerSize = Array[1..3] of Integer ;

  TfMarker = class(TForm)
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    gMrkSze : iMarkerSize;

  end;

var
  fMarker: TfMarker;

implementation

{$R *.lfm}

{ TfMarker }

procedure TfMarker.FormCreate(Sender: TObject);
begin
  gMrkSze[1] := 4;
  gMrkSze[2] := 2;
  gMrkSze[3] := 2;
end;

procedure TfMarker.ComboBox1Change(Sender: TObject);
begin
  gMrkSze[1] := StrToInt(ComboBox1.Text);
end;

procedure TfMarker.ComboBox2Change(Sender: TObject);
begin
  gMrkSze[2] := StrToInt(ComboBox2.Text);
end;

procedure TfMarker.ComboBox3Change(Sender: TObject);
begin
  gMrkSze[3] := StrToInt(ComboBox3.Text);
end;

end.

