unit ulclfeeding1;

{
  Feeding Origin 2 is software that supports calculation of nutrient requirement of livestock
  and feed design based on Japanese feeding standard.
  Copyright (C) 2017,  Syuichiro Fukagawa.

  This program is free software; you can redistribute it and/or modify it under the terms of
  the GNU General Public License as published by the Free Software Foundation; either version 3
  of the License, or (at your option) any later version.
  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  You should have received a copy of the GNU General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.


  Feeding Origin 2 は、日本飼養標準に基づいた家畜の養分要求量の計算および飼料設計を支援するソフ
  トウェアです.
  Copyright (C) 2017,　深川修一郎.

  　このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア財団によって
  発行されたGNU一般公衆利用許諾書(バージョン3か、それ以降のバージョンのうちどれか)が定める
  条件の下で再頒布または改変することができます。
  このプログラムは有用であることを願って頒布されますが、*全くの無保証* です。商業可能性の保証
  や特定目的への適合性は、言外に示されたものも含め、全く存在しません。詳しくはGNU一般公衆利用
  許諾書をご覧ください。
  　あなたはこのプログラムと共に、GNU一般公衆利用許諾書のコピーを一部 受け取っているはずです。
  もし受け取っていなければ、<http://www.gnu.org/licenses/> をご覧ください。
  
  *本日本語訳は、FSFより2007年6月29日に発行されたGNU GPL v3の原文から、八田真行氏が翻訳した
   ものを基にしています。 ＜ https://mag.osdn.jp/07/09/02/130237 ＞
}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ComCtrls,
  ExtCtrls, StdCtrls, u_feedingcalc2, u_CommonModule, LCLType ;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    LabeledEdit1: TLabeledEdit;
    LabeledEdit10: TLabeledEdit;
    LabeledEdit2: TLabeledEdit;
    LabeledEdit3: TLabeledEdit;
    LabeledEdit4: TLabeledEdit;
    LabeledEdit5: TLabeledEdit;
    LabeledEdit6: TLabeledEdit;
    LabeledEdit7: TLabeledEdit;
    Memo1: TMemo;
    Memo2: TMemo;
    Memo3: TMemo;
    PageControl1: TPageControl;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    RadioGroup4: TRadioGroup;
    RadioGroup5: TRadioGroup;
    RadioGroup6: TRadioGroup;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure CBoxKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure CheckBox5Change(Sender: TObject);
    procedure GeneralKeyPress(Sender: TObject; var Key: char);
    procedure LabeledEdit7Change(Sender: TObject);
    procedure LimitationPredeliveryPeriod(Sender: TObject);
    procedure EnterRadioButton(Sender: TObject);
    procedure RadioGroup2KeyPress(Sender: TObject; var Key: char);
    procedure RGroupKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure TabSheet1Show(Sender: TObject);
    procedure TabSheet2Show(Sender: TObject);
    procedure TabSheet3Show(Sender: TObject);

  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.FormActivate(Sender: TObject);
begin
  LabeledEdit2.SetFocus;
  RadioGroup4.Controls[0].Enabled := False;
end;

//*** 搾乳牛の養分要求量計算 ***
procedure TForm1.Button3Click(Sender: TObject);
Type
    AMsg = Array[0..12] of String ;
var
    stM  : reMILK ;
    stR  : reNUTRIENT ;
    cMsg : AMsg ;
    i    : Integer ;
    dWrk : Double ;
begin
  //入力チェック
    //空白のチェック
     if  Trim( LabeledEdit2.Text ) = ''  then
        begin
          ShowMessage( '乳量を入力してください。' );
          LabeledEdit2.SetFocus;
          exit;
        end;
     if  Trim( LabeledEdit3.Text ) = ''  then
        begin
          ShowMessage( '乳脂率を入力してください。' );
          LabeledEdit3.SetFocus;
          exit;
        end;
     if  Trim( LabeledEdit4.Text ) = ''  then
        begin
          ShowMessage( '体重を入力してください。' );
          LabeledEdit4.SetFocus;
          exit;
        end;
     if  Trim( LabeledEdit5.Text ) = ''  then
        begin
          ShowMessage( '分娩後週を入力してください。' );
          LabeledEdit5.SetFocus;
          exit;
        end;

    //数値入力範囲のチェック
    dWrk := StrToFloat(LabeledEdit2.Text);           //乳量
    if ( dWrk < 0 ) or ( dWrk > 100 )  then
       begin
         ShowMessage( '乳量は0kg以上かつ100kg以下を入力します。' );
         LabeledEdit2.SetFocus;
         exit;
       end;

    dWrk := StrToFloat(LabeledEdit3.Text);           //乳脂率
    if ( dWrk < 0 ) or ( dWrk > 10 )  then
       begin
         ShowMessage( '乳脂率は0%以上かつ10%以下を入力します。' );
         LabeledEdit3.SetFocus;
         exit;
       end;

    dWrk := StrToFloat(LabeledEdit4.Text);           //体重
    if ( dWrk < 200 ) or ( dWrk > 1000 )  then
       begin
         ShowMessage( '体重は200kg以上かつ1000kg以下を入力します。' );
         LabeledEdit4.SetFocus;
         exit;
       end;

    dWrk := StrToFloat(LabeledEdit5.Text);           //分娩後週
    if ( dWrk < 0 ) or ( dWrk > 60 )  then
       begin
         ShowMessage( '分娩後週は0週以上かつ60週以下を入力します。' );
         LabeledEdit5.SetFocus;
         exit;
       end;

  //計算処理へ渡すデータの編集
    stM.dYld1  := StrToFloat(LabeledEdit2.Text);           //乳量
    stM.dFat   := StrToFloat(LabeledEdit3.Text);           //乳脂率
    stM.dWt1   := StrToFloat(LabeledEdit4.Text);           //体重
    stM.dWkbrt := StrToFloat(LabeledEdit5.Text);           //分娩後週
    case RadioGroup1.ItemIndex of                          //飼料給与方式
        0 : stM.cFed := '分離' ;
        1 : stM.cFed := 'TMR'  ;
    end;
    stM.dKion  := StrToFloat(LabeledEdit6.Text);  	   //平均気温
    case RadioGroup2.ItemIndex of                          //産次
	0 : stM.cBrfq := '初産分娩後' ;
	1 : stM.cBrfq := '2産分娩から3産分娩まで' ;
	2 : stM.cBrfq := '3産分娩以後' ;
    end;
    if CheckBox1.Checked then                             //CPの最低値をDMの12%に設定
        stM.cLVCP := 'ON'
    else
        stM.cLVCP := 'OFF' ;

  //計算処理
    stR := MilkingCow( stM );

  //計算結果の編集
    cMsg[0]  := '[条件]　　　　　　　　　　　　　　　　　　[結果]';
    cMsg[1]  := LengthEdit('　乳量：　　　　'   + FloatEdit(stM.dYld1,  0, 5) + '    kg', 44);
    cMsg[2]  := LengthEdit('　乳脂率：　　　'   + FloatEdit(stM.dFat,   1, 5) + '  %', 44);
    cMsg[3]  := LengthEdit('　体重：　　　　'   + FloatEdit(stM.dWt1,   0, 5) + '    kg', 44);
    cMsg[4]  := LengthEdit('　分娩後：　　　'   + FloatEdit(stM.dWkbrt, 0, 5) + '    週', 44);
    cMsg[5]  := LengthEdit('　飼料給与方式：　' + stM.cFed, 44);
    cMsg[6]  := LengthEdit('　平均気温：　　'   + FloatEdit(stM.dKion, 0, 5)  + '    ℃', 44);
    cMsg[7]  := LengthEdit('　産次：　　　　　' + stM.cBrfq, 44);
    cMsg[8]  := LengthEdit('　CPの最低値：　　' + stM.cLVCP, 44);
    cMsg[9]  := LengthEdit('　　　　　　　　', 44);
    cMsg[10] := LengthEdit('　　　　　　　　', 44);
    cMsg[11] := LengthEdit('　　　　　　　　', 44);
    cMsg[12] := LengthEdit('　　　　　　　　', 44);

    cMsg[1]  := cMsg[1]  + ('ＦＣＭ：　　　　　　　　　　　' + FloatEdit(stR.dFCM,  1, 5) + '  kg');
    cMsg[2]  := cMsg[2]  + ('乾物摂取量(DM)：　　　　　　　' + FloatEdit(stR.dDMI,  2, 5) + ' kg');
    cMsg[3]  := cMsg[3]  + ('粗蛋白質要求量(CP)：　　　　　' + FloatEdit(stR.dCP,   0, 5) + '    g');
    cMsg[4]  := cMsg[4]  + ('可消化蛋白質要求量(DCP)：　　 ' + FloatEdit(stR.dDCP,  0, 5) + '    g');
    cMsg[5]  := cMsg[5]  + ('可消化養分総量(TDN)：　　　　 ' + FloatEdit(stR.dTDN,  2, 5) + ' kg');
    cMsg[6]  := cMsg[6]  + ('可消化エネルギー(DE)：　　　　' + FloatEdit(stR.dDE,   2, 5) + ' Mcal');
    cMsg[7]  := cMsg[7]  + ('代謝エネルギーの総要求量(ME)：' + FloatEdit(stR.dMEC,  2, 5) + ' Mcal');
    cMsg[8]  := cMsg[8]  + ('代謝エネルギーの総要求量(ME)：' + FloatEdit(stR.dMEJ,  2, 5) + ' MJ');
    cMsg[9]  := cMsg[9]  + ('カルシウム要求量：　　　　　　' + FloatEdit(stR.dCa,   1, 5) + '  g');
    cMsg[10] := cMsg[10] + ('リン要求量：　　　　　　　　　' + FloatEdit(stR.dP,    1, 5) + '  g');
    cMsg[11] := cMsg[11] + ('ビタミンＡ要求量：　　　　　　' + FloatEdit(stR.dVA,   1, 5) + '  1000IU');
    cMsg[12] := cMsg[12] + ('ビタミンＤ要求量：　　　　　　' + FloatEdit(stR.dVD,   1, 5) + '  1000IU');

  //計算結果の画面出力
    for i :=0 to 12 do
  	Memo1.Lines.Add( cMsg[i] ) ;
    Memo1.Lines.Add('');
end;

//*** 乾乳牛の養分要求量計算 ***
procedure TForm1.Button2Click(Sender: TObject);
Type
    AMsg = Array[0..12] of String ;
var
    stD  : reDRY ;
    stR  : reNUTRIENT ;
    cMsg : AMsg ;
    i    : Integer ;
    dWrk : Double ;
begin
  //入力チェック
    //空白のチェック
    if  Trim( LabeledEdit1.Text ) = ''  then
       begin
         ShowMessage( '体重を入力してください。' );
         LabeledEdit1.SetFocus;
         exit;
       end;

    //数値入力範囲のチェック
    dWrk := StrToFloat( LabeledEdit1.Text );    	// 体重
    if ( dWrk < 200 ) or ( dWrk > 1000 )  then
       begin
         ShowMessage( '体重は200kg以上かつ1000kg以下を入力します。' );
         LabeledEdit1.SetFocus;
         exit;
       end;

  //計算処理へ渡すデータの編集
    stD.dWt1 := StrToFloat( LabeledEdit1.Text );    	// 体重

    case RadioGroup3.ItemIndex of                       // 分娩前
        0:  stD.cPre := '分娩前9週から4週まで' ;
        1:  stD.cPre := '分娩前3週から分娩まで' ;
        2:  stD.cPre := 'それ以外' ;
    end;

    if ( CheckBox2.Checked ) then                       // 分娩１週間前(乾物摂取量に考慮)
        stD.cWkb := 'ON'
    else
        stD.cWkb := 'OFF' ;

    if ( CheckBox3.Checked ) then                       // CPの最低値をDMの12%に設定する
        stD.cLVCP := 'ON'
    else
        stD.cLVCP := 'OFF' ;

    case RadioGroup4.ItemIndex of                       // 胎子の品種
        0:  stD.cKind := 'ﾎﾙｽﾀｲﾝ(初妊)' ;
        1:  stD.cKind := 'ﾎﾙｽﾀｲﾝ(経産)' ;
        2:  stD.cKind := '黒毛和種単子' ;
        3:  stD.cKind := '黒毛和種双子' ;
        4:  stD.cKind := '交雑種' ;
    end;

  //計算処理
    stR := DryingCow_A( stD );

  //計算結果の編集
   cMsg[0]  := '[条件]　　　　　　　　　　　　　　　　　　[結果]';
   cMsg[1]  := LengthEdit('　体重：　　　　' + FloatEdit(stD.dWt1,  0, 5) + '  kg', 44);
   cMsg[2]  := LengthEdit('　分娩前：　　　' + stD.cPre, 44);
   cMsg[3]  := LengthEdit('　分娩1週間前： ' + stD.cWkb, 44);
   cMsg[4]  := LengthEdit('　CPの最低値：  ' + stD.cLVCP, 44);
   cMsg[5]  := LengthEdit('　胎子の品種：　' + stD.cKind, 44);
   cMsg[6]  := LengthEdit('　　　　　　　　', 44);
   cMsg[7]  := LengthEdit('　　　　　　　　', 44);
   cMsg[8]  := LengthEdit('　　　　　　　　', 44);
   cMsg[9]  := LengthEdit('　　　　　　　　', 44);
   cMsg[10] := LengthEdit('　　　　　　　　', 44);
   cMsg[11] := LengthEdit('　　　　　　　　', 44);
   cMsg[12] := LengthEdit('　　　　　　　　', 44);

   cMsg[1]  := cMsg[1]  + ('ＦＣＭ：　　　　　　　　　　　' + FloatEdit(stR.dFCM,  1, 5) + '  kg');
   cMsg[2]  := cMsg[2]  + ('乾物摂取量(DM)：　　　　　　　' + FloatEdit(stR.dDMI,  2, 5) + ' kg');
   cMsg[3]  := cMsg[3]  + ('粗蛋白質要求量(CP)：　　　　　' + FloatEdit(stR.dCP,   0, 5) + '    g');
   cMsg[4]  := cMsg[4]  + ('可消化蛋白質要求量(DCP)：　　 ' + FloatEdit(stR.dDCP,  0, 5) + '    g');
   cMsg[5]  := cMsg[5]  + ('可消化養分総量(TDN)：　　　　 ' + FloatEdit(stR.dTDN,  2, 5) + ' kg');
   cMsg[6]  := cMsg[6]  + ('可消化エネルギー(DE)：　　　　' + FloatEdit(stR.dDE,   2, 5) + ' Mcal');
   cMsg[7]  := cMsg[7]  + ('代謝エネルギーの総要求量(ME)：' + FloatEdit(stR.dMEC,  2, 5) + ' Mcal');
   cMsg[8]  := cMsg[8]  + ('代謝エネルギーの総要求量(ME)：' + FloatEdit(stR.dMEJ,  2, 5) + ' MJ');
   cMsg[9]  := cMsg[9]  + ('カルシウム要求量：　　　　　　' + FloatEdit(stR.dCa,   1, 5) + '  g');
   cMsg[10] := cMsg[10] + ('リン要求量：　　　　　　　　　' + FloatEdit(stR.dP,    1, 5) + '  g');
   cMsg[11] := cMsg[11] + ('ビタミンＡ要求量：　　　　　　' + FloatEdit(stR.dVA,   1, 5) + '  1000IU');
   cMsg[12] := cMsg[12] + ('ビタミンＤ要求量：　　　　　　' + FloatEdit(stR.dVD,   1, 5) + '  1000IU');

  //計算結果の画面出力
  for i :=0 to 12 do
	Memo2.Lines.Add( cMsg[i] ) ;
  Memo2.Lines.Add('');
end;

//*** 育成牛の養分要求量計算 ***
procedure TForm1.Button1Click(Sender: TObject);
Type
    AMsg = Array[0..12] of String ;
var
    stG  : reGROW ;
    stR  : reNUTRIENT ;
    cMsg : AMsg ;
    i    : Integer ;
    dWrk : Double ;
begin
  //入力チェック
    //空白のチェック
    if  Trim( LabeledEdit7.Text ) = ''  then
       begin
         ShowMessage( '体重を入力してください。' );
         LabeledEdit7.SetFocus;
         exit;
       end;

    if  Trim( LabeledEdit10.Text ) = ''  then
       begin
         ShowMessage( '日増体重を入力してください。' );
         LabeledEdit10.SetFocus;
         exit;
       end;

    //数値範囲のチェック
    dWrk := StrToFloat( LabeledEdit7.Text ) ;  // 体重
    if ( dWrk < 10 ) or ( dWrk > 600 )  then
       begin
         ShowMessage( '体重は10kg以上かつ600kg以下を入力します。' );
         LabeledEdit7.SetFocus;
         exit;
       end;

    dWrk := StrToFloat( LabeledEdit10.Text ) ; // 日増体重
    if ( dWrk < 0 ) or ( dWrk > 2 )  then
       begin
         ShowMessage( '１日の増体重は0kg以上かつ2kg以下を入力します。' );
         LabeledEdit10.SetFocus;
         exit;
       end;

  //計算処理へ渡すデータの編集
    stG.dWt1   := StrToFloat( LabeledEdit7.Text ) ;  // 体重
    stG.dInWt1 := StrToFloat( LabeledEdit10.Text ) ; // 日増体重

    if ( CheckBox4.Checked )  then                   // CPの最低値
        stG.cLVCP := 'ON'
    else
        stG.cLVCP := 'OFF';

    case  RadioGroup6.ItemIndex  of                  // 季節の考慮
        0  :  stG.cKset := '考慮しない' ;
    	1  :  stG.cKset := '夏期' ;
    	2  :  stG.cKset := '冬期' ;
    	3  :  stG.cKset := '冬期(厳寒地)' ;
    end;

    case  RadioGroup5.ItemIndex  of  // 離乳(0：離乳前、1：離乳後 、体重が66kg＜X＜75kg )
    	0  :  stG.cWean := '離乳前' ;
    	1  :  stG.cWean := '離乳後' ;
    end;

  //計算処理
    stR := GrowingCow_A( stG );

  //計算結果の編集

    cMsg[0]  := '[条件]　　　　　　　　　　　　　　　　　　[結果]';
    cMsg[1]  := LengthEdit('　体重：　　　　　'   + FloatEdit(stG.dWt1,    0, 5) + '  　kg', 44);
    cMsg[2]  := LengthEdit('　１日増体重：　　'   + FloatEdit(stG.dInWt1,  1, 5) + '  kg', 44);
    cMsg[3]  := LengthEdit('　離乳(66～75kg)：　' + stG.cWean, 44);
    cMsg[4]  := LengthEdit('　CPの最低値：  　　' + stG.cLVCP, 44);
    cMsg[5]  := LengthEdit('　季節の考慮：　　　' + stG.cKset, 44);
    cMsg[6]  := LengthEdit('　　　　　　　　', 44);
    cMsg[7]  := LengthEdit('　　　　　　　　', 44);
    cMsg[8]  := LengthEdit('　　　　　　　　', 44);
    cMsg[9]  := LengthEdit('　　　　　　　　', 44);
    cMsg[10] := LengthEdit('　　　　　　　　', 44);
    cMsg[11] := LengthEdit('　　　　　　　　', 44);
    cMsg[12] := LengthEdit('　　　　　　　　', 44);

    cMsg[1]  := cMsg[1]  + ('ＦＣＭ：　　　　　　　　　　　' + FloatEdit(stR.dFCM,  1, 5) + '  kg');
    cMsg[2]  := cMsg[2]  + ('乾物摂取量(DM)：　　　　　　　' + FloatEdit(stR.dDMI,  2, 5) + ' kg');
    cMsg[3]  := cMsg[3]  + ('粗蛋白質要求量(CP)：　　　　　' + FloatEdit(stR.dCP,   0, 5) + '    g');
    cMsg[4]  := cMsg[4]  + ('可消化蛋白質要求量(DCP)：　　 ' + FloatEdit(stR.dDCP,  0, 5) + '    g');
    cMsg[5]  := cMsg[5]  + ('可消化養分総量(TDN)：　　　　 ' + FloatEdit(stR.dTDN,  2, 5) + ' kg');
    cMsg[6]  := cMsg[6]  + ('可消化エネルギー(DE)：　　　　' + FloatEdit(stR.dDE,   2, 5) + ' Mcal');
    cMsg[7]  := cMsg[7]  + ('代謝エネルギーの総要求量(ME)：' + FloatEdit(stR.dMEC,  2, 5) + ' Mcal');
    cMsg[8]  := cMsg[8]  + ('代謝エネルギーの総要求量(ME)：' + FloatEdit(stR.dMEJ,  2, 5) + ' MJ');
    cMsg[9]  := cMsg[9]  + ('カルシウム要求量：　　　　　　' + FloatEdit(stR.dCa,   1, 5) + '  g');
    cMsg[10] := cMsg[10] + ('リン要求量：　　　　　　　　　' + FloatEdit(stR.dP,    1, 5) + '  g');
    cMsg[11] := cMsg[11] + ('ビタミンＡ要求量：　　　　　　' + FloatEdit(stR.dVA,   1, 5) + '  1000IU');
    cMsg[12] := cMsg[12] + ('ビタミンＤ要求量：　　　　　　' + FloatEdit(stR.dVD,   1, 5) + '  1000IU');

  //計算結果の画面出力
    for i :=0 to 12 do
        Memo3.Lines.Add( cMsg[i] ) ;
    Memo3.Lines.Add('');
end;

procedure TForm1.GeneralKeyPress(Sender: TObject; var Key: char);
begin
    ComEditKeyPress(Form1, Sender, Key);
end;

////*** 育成牛の体重が66kg＜X＜75kgの時の離乳時期の入力制限　***
procedure TForm1.LabeledEdit7Change(Sender: TObject);
var
    dWeight, dR : Double ;
begin
    if  ( Trim(LabeledEdit7.Text) <> '' )  then
      begin
        dWeight := StrToFloat( LabeledEdit7.Text ) ;  // 体重
        // 離乳判別
        if ( dWeight > 66 ) and ( dWeight < 75 )  then
            RadioGroup5.Enabled := true
        else
            if ( dWeight <= 66 )  then
               begin
                   RadioGroup5.Enabled   := false ;
                   RadioGroup5.ItemIndex := 0 ;
               end
            else if ( dWeight >= 75 )  then
               begin
                   RadioGroup5.Enabled   := false ;
                   RadioGroup5.ItemIndex := 1 ;
               end;
        // 1日増体重の標準値を入力
        if CheckBox5.Checked then
          begin
            dR := StandardDailyWeightGain(dWeight);
            LabeledEdit10.Text := FloatToStrF(dR,ffFixed,1,1);
          end;
      end;
end;

//*** ホルスタイン初任牛の分娩前期間の選択制限 ***
procedure TForm1.LimitationPredeliveryPeriod(Sender: TObject);
begin
    if  RadioGroup4.ItemIndex = 0 then
          RadioGroup3.Controls[2].Enabled:=False
    else
          RadioGroup3.Controls[2].Enabled:=True;

    if  RadioGroup3.ItemIndex = 2 then
          RadioGroup4.Controls[0].Enabled:=False
    else
          RadioGroup4.Controls[0].Enabled:=True;
end;

procedure TForm1.EnterRadioButton(Sender: TObject);
var
    RB  :  TRadioButton ;
begin
    RB := Sender  as  TRadioButton ;
    RB.Checked := true ;
end;

procedure TForm1.RadioGroup2KeyPress(Sender: TObject; var Key: char);
begin
    if Key = chr(VK_RETURN) then
      Form1.SelectNext(Sender as TWinControl, True, True );  // フォーカス移動（前進）
end;

procedure TForm1.RGroupKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
    ComRGKeyDown( Form1, Sender, Key, Shift );
end;

procedure TForm1.TabSheet1Show(Sender: TObject);
begin
    if  Form1.Active  then  LabeledEdit2.SetFocus;
end;

procedure TForm1.TabSheet2Show(Sender: TObject);
begin
    if  Form1.Active  then  LabeledEdit1.SetFocus;
end;


procedure TForm1.TabSheet3Show(Sender: TObject);
begin
    if  Form1.Active  then  LabeledEdit7.SetFocus;
end;

procedure TForm1.CBoxKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
     ComCBKeyDown( Form1, Sender, Key, Shift );
end;

//***** 標準の１日の増体重
procedure TForm1.CheckBox5Change(Sender: TObject);
  var dW, dR : Double;
begin
  if CheckBox5.Checked then
    begin
      LabeledEdit10.Enabled:=False;
      dW := StrToFloat(LabeledEdit7.Text);
      dR := StandardDailyWeightGain(dW);
      LabeledEdit10.Text := FloatToStrF(dR,ffFixed,1,1);
    end
  else
    begin
      LabeledEdit10.Enabled:=True;
    end;
end;



end.

