/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.action.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.Constants;
import jp.sf.fess.crud.util.SAStrutsUtil;
import jp.sf.fess.form.admin.CrawlForm;
import jp.sf.fess.util.FessProperties;

import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlAction implements Serializable {
    private static final Logger logger = LoggerFactory
            .getLogger(CrawlAction.class);

    private static final long serialVersionUID = 1L;

    @ActionForm
    @Resource
    protected CrawlForm crawlForm;

    @Resource
    protected FessProperties crawlerProperties;

    protected String showIndex(boolean redirect) {
        crawlForm.cronExpression = crawlerProperties.getProperty(
                Constants.CRON_EXPRESSION_PROPERTY,
                Constants.DEFAULT_CRON_EXPRESSION);
        crawlForm.optimize = crawlerProperties.getProperty(
                Constants.OPTIMIZE_PROPERTY, "true");
        crawlForm.commit = crawlerProperties.getProperty(
                Constants.COMMIT_PROPERTY, "true");
        crawlForm.serverRotation = crawlerProperties.getProperty(
                Constants.SERVER_ROTATION_PROPERTY, "true");
        crawlForm.dayForCleanup = crawlerProperties.getProperty(
                Constants.DAY_FOR_CLEANUP_PROPERTY, "1");
        crawlForm.commitPerCount = crawlerProperties.getProperty(
                Constants.COMMIT_PER_COUNT_PROPERTY, Long
                        .toString(Constants.DEFAULT_COMMIT_PER_COUNT));
        crawlForm.crawlingThreadCount = crawlerProperties.getProperty(
                Constants.CRAWLING_THREAD_COUNT_PROPERTY, "5");
        crawlForm.mobileTranscoder = crawlerProperties.getProperty(
                Constants.MOBILE_TRANSCODER_PROPERTY, Constants.EMPTY_STRING);
        crawlForm.snapshotReplication = crawlerProperties.getProperty(
                Constants.SNAPSHOT_REPLICATION_PROPERTY, "false");
        crawlForm.snapshotPath = crawlerProperties.getProperty(
                Constants.SNAPSHOT_PATH_PROPERTY, Constants.EMPTY_STRING);
        if (redirect) {
            return "index?redirect=true";
        } else {
            return "index.jsp";
        }
    }

    @Execute(validator = false)
    public String index() {
        return showIndex(false);
    }

    @Execute(validator = true, input = "index.jsp")
    public String update() {
        crawlerProperties.setProperty(Constants.CRON_EXPRESSION_PROPERTY,
                crawlForm.cronExpression);
        crawlerProperties
                .setProperty(
                        Constants.OPTIMIZE_PROPERTY,
                        crawlForm.optimize != null
                                && "on".equalsIgnoreCase(crawlForm.optimize) ? Constants.TRUE
                                : Constants.FALSE);
        crawlerProperties
                .setProperty(
                        Constants.COMMIT_PROPERTY,
                        crawlForm.commit != null
                                && "on".equalsIgnoreCase(crawlForm.commit) ? Constants.TRUE
                                : Constants.FALSE);
        crawlerProperties
                .setProperty(
                        Constants.SERVER_ROTATION_PROPERTY,
                        crawlForm.serverRotation != null
                                && "on"
                                        .equalsIgnoreCase(crawlForm.serverRotation) ? Constants.TRUE
                                : Constants.FALSE);
        crawlerProperties.setProperty(Constants.DAY_FOR_CLEANUP_PROPERTY,
                crawlForm.dayForCleanup);
        crawlerProperties.setProperty(Constants.COMMIT_PER_COUNT_PROPERTY,
                crawlForm.commitPerCount);
        crawlerProperties.setProperty(Constants.CRAWLING_THREAD_COUNT_PROPERTY,
                crawlForm.crawlingThreadCount);
        crawlerProperties.setProperty(Constants.MOBILE_TRANSCODER_PROPERTY,
                crawlForm.mobileTranscoder);
        crawlerProperties
                .setProperty(
                        Constants.SNAPSHOT_REPLICATION_PROPERTY,
                        crawlForm.snapshotReplication != null
                                && "on"
                                        .equalsIgnoreCase(crawlForm.snapshotReplication) ? Constants.TRUE
                                : Constants.FALSE);
        crawlerProperties.setProperty(Constants.SNAPSHOT_PATH_PROPERTY,
                crawlForm.snapshotPath);
        try {
            crawlerProperties.setProperty(Constants.CRON_EXPRESSION_PROPERTY,
                    crawlForm.cronExpression);
            crawlerProperties.store();
            SAStrutsUtil.addSessionMessage("success.update_crawler_params");
            return showIndex(true);
        } catch (Exception e) {
            logger.error("Failed to update crawler parameters.", e);
            throw new ActionMessagesException(
                    "errors.failed_to_update_crawler_params", e);
        }
    }

    public List<String> getDayItems() {
        List<String> items = new ArrayList<String>();
        for (int i = 1; i < 11; i++) {
            items.add(Integer.valueOf(i).toString());
        }
        return items;
    }

    public List<Map<String, String>> getMobileTranscoderItems() {
        List<Map<String, String>> mobileTranscoderList = new ArrayList<Map<String, String>>();
        // TODO i18n
        mobileTranscoderList.add(createItem("-", Constants.EMPTY_STRING));
        mobileTranscoderList.add(createItem("Google",
                Constants.GOOGLE_MOBILE_TRANSCODER));
        return mobileTranscoderList;
    }

    private Map<String, String> createItem(String label, String value) {
        Map<String, String> map = new HashMap<String, String>();
        map.put(Constants.ITEM_LABEL, label);
        map.put(Constants.ITEM_VALUE, value);
        return map;

    }
}