/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.ant.sax;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sf.fess.ant.sax.XdocToTexHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.helpers.DefaultHandler;

public class XdocToTexParser {
    private String charset = "UTF-8";
    private Task task;

    public void parse(File srcFile, File destFile) {
        this.log("Input:  " + srcFile.getAbsolutePath());
        this.log("Output: " + destFile.getAbsolutePath());
        FileInputStream fis = null;
        BufferedWriter bw = null;
        try {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser sp = spf.newSAXParser();
                fis = new FileInputStream(srcFile);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), this.charset));
                XdocToTexHandler sh = new XdocToTexHandler(bw);
                sp.parse((InputStream)fis, (DefaultHandler)sh);
                bw.flush();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void log(String msg) {
        if (this.task != null) {
            this.task.log(msg);
        } else {
            System.out.println(msg);
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setTask(Task Task2) {
        this.task = this.task;
    }
}

