/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.OverlappingHostCB;
import jp.sf.fess.db.cbean.cq.OverlappingHostCQ;
import jp.sf.fess.db.cbean.cq.ciq.OverlappingHostCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of OVERLAPPING_HOST.
 * @author DBFlute(AutoGenerator)
 */
public class BsOverlappingHostCQ extends AbstractBsOverlappingHostCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected OverlappingHostCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsOverlappingHostCQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from OVERLAPPING_HOST) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public OverlappingHostCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new OverlappingHostCIQ(getChildQuery(),
                    getSqlClause(), getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join OVERLAPPING_HOST on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public OverlappingHostCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        OverlappingHostCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    public BsOverlappingHostCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _regularName;

    public ConditionValue getRegularName() {
        if (_regularName == null) {
            _regularName = nCV();
        }
        return _regularName;
    }

    protected ConditionValue getCValueRegularName() {
        return getRegularName();
    }

    public BsOverlappingHostCQ addOrderBy_RegularName_Asc() {
        regOBA("REGULAR_NAME");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_RegularName_Desc() {
        regOBD("REGULAR_NAME");
        return this;
    }

    protected ConditionValue _overlappingName;

    public ConditionValue getOverlappingName() {
        if (_overlappingName == null) {
            _overlappingName = nCV();
        }
        return _overlappingName;
    }

    protected ConditionValue getCValueOverlappingName() {
        return getOverlappingName();
    }

    public BsOverlappingHostCQ addOrderBy_OverlappingName_Asc() {
        regOBA("OVERLAPPING_NAME");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_OverlappingName_Desc() {
        regOBD("OVERLAPPING_NAME");
        return this;
    }

    protected ConditionValue _sortOrder;

    public ConditionValue getSortOrder() {
        if (_sortOrder == null) {
            _sortOrder = nCV();
        }
        return _sortOrder;
    }

    protected ConditionValue getCValueSortOrder() {
        return getSortOrder();
    }

    public BsOverlappingHostCQ addOrderBy_SortOrder_Asc() {
        regOBA("SORT_ORDER");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_SortOrder_Desc() {
        regOBD("SORT_ORDER");
        return this;
    }

    protected ConditionValue _createdBy;

    public ConditionValue getCreatedBy() {
        if (_createdBy == null) {
            _createdBy = nCV();
        }
        return _createdBy;
    }

    protected ConditionValue getCValueCreatedBy() {
        return getCreatedBy();
    }

    public BsOverlappingHostCQ addOrderBy_CreatedBy_Asc() {
        regOBA("CREATED_BY");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_CreatedBy_Desc() {
        regOBD("CREATED_BY");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    public BsOverlappingHostCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    protected ConditionValue _updatedBy;

    public ConditionValue getUpdatedBy() {
        if (_updatedBy == null) {
            _updatedBy = nCV();
        }
        return _updatedBy;
    }

    protected ConditionValue getCValueUpdatedBy() {
        return getUpdatedBy();
    }

    public BsOverlappingHostCQ addOrderBy_UpdatedBy_Asc() {
        regOBA("UPDATED_BY");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_UpdatedBy_Desc() {
        regOBD("UPDATED_BY");
        return this;
    }

    protected ConditionValue _updatedTime;

    public ConditionValue getUpdatedTime() {
        if (_updatedTime == null) {
            _updatedTime = nCV();
        }
        return _updatedTime;
    }

    protected ConditionValue getCValueUpdatedTime() {
        return getUpdatedTime();
    }

    public BsOverlappingHostCQ addOrderBy_UpdatedTime_Asc() {
        regOBA("UPDATED_TIME");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_UpdatedTime_Desc() {
        regOBD("UPDATED_TIME");
        return this;
    }

    protected ConditionValue _deletedBy;

    public ConditionValue getDeletedBy() {
        if (_deletedBy == null) {
            _deletedBy = nCV();
        }
        return _deletedBy;
    }

    protected ConditionValue getCValueDeletedBy() {
        return getDeletedBy();
    }

    public BsOverlappingHostCQ addOrderBy_DeletedBy_Asc() {
        regOBA("DELETED_BY");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_DeletedBy_Desc() {
        regOBD("DELETED_BY");
        return this;
    }

    protected ConditionValue _deletedTime;

    public ConditionValue getDeletedTime() {
        if (_deletedTime == null) {
            _deletedTime = nCV();
        }
        return _deletedTime;
    }

    protected ConditionValue getCValueDeletedTime() {
        return getDeletedTime();
    }

    public BsOverlappingHostCQ addOrderBy_DeletedTime_Asc() {
        regOBA("DELETED_TIME");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_DeletedTime_Desc() {
        regOBD("DELETED_TIME");
        return this;
    }

    protected ConditionValue _versionNo;

    public ConditionValue getVersionNo() {
        if (_versionNo == null) {
            _versionNo = nCV();
        }
        return _versionNo;
    }

    protected ConditionValue getCValueVersionNo() {
        return getVersionNo();
    }

    public BsOverlappingHostCQ addOrderBy_VersionNo_Asc() {
        regOBA("VERSION_NO");
        return this;
    }

    public BsOverlappingHostCQ addOrderBy_VersionNo_Desc() {
        regOBD("VERSION_NO");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsOverlappingHostCQ addSpecifiedDerivedOrderBy_Asc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsOverlappingHostCQ addSpecifiedDerivedOrderBy_Desc(String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, OverlappingHostCQ> _scalarSubQueryMap;

    public Map<String, OverlappingHostCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(OverlappingHostCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, OverlappingHostCQ> _myselfInScopeSubQueryMap;

    public Map<String, OverlappingHostCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(OverlappingHostCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return OverlappingHostCB.class.getName();
    }

    String xCQ() {
        return OverlappingHostCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
