/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.service;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.fess.crud.CrudMessageException;
import jp.sf.fess.crud.service.BsLabelTypeService;
import jp.sf.fess.db.cbean.LabelTypeCB;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.helper.LabelTypeHelper;
import jp.sf.fess.pager.LabelTypePager;

import org.seasar.framework.container.SingletonS2Container;

public class LabelTypeService extends BsLabelTypeService implements
        Serializable {

    private static final long serialVersionUID = 1L;

    protected void setupListCondition(LabelTypeCB cb,
            LabelTypePager labelTypePager) {
        super.setupListCondition(cb, labelTypePager);

        // setup condition
        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();
        cb.query().addOrderBy_Name_Asc();
        // search

    }

    protected void setupEntityCondition(LabelTypeCB cb, Map<String, String> keys) {
        super.setupEntityCondition(cb, keys);

        // setup condition
        cb.query().setDeletedBy_IsNull();

    }

    protected void setupStoreCondition(LabelType labelType) {
        super.setupStoreCondition(labelType);

        // setup condition

    }

    protected void setupDeleteCondition(LabelType labelType) {
        super.setupDeleteCondition(labelType);

        // setup condition

    }

    public List<LabelType> getLabelTypeList() {
        LabelTypeCB cb = new LabelTypeCB();
        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();
        cb.query().addOrderBy_Name_Asc();
        return labelTypeBhv.selectList(cb);
    }

    @Override
    public void store(LabelType labelType) throws CrudMessageException {
        super.store(labelType);

        LabelTypeHelper labelTypeHelper = SingletonS2Container
                .getComponent("labelTypeHelper");
        if (labelTypeHelper != null) {
            labelTypeHelper.refresh(getLabelTypeList());
        }
    }

}
