/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.LabelTypeDbm;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.LabelTypeCB;
import jp.sf.fess.db.cbean.LabelTypeToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.exbhv.DataConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.LabelTypeBhv;
import jp.sf.fess.db.exbhv.LabelTypeToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.LabelType;
import jp.sf.fess.db.exentity.LabelTypeToRoleTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of LABEL_TYPE as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     DATA_CONFIG_TO_LABEL_TYPE_MAPPING, FILE_CONFIG_TO_LABEL_TYPE_MAPPING, LABEL_TYPE_TO_ROLE_TYPE_MAPPING, WEB_CONFIG_TO_LABEL_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     dataConfigToLabelTypeMappingList, fileConfigToLabelTypeMappingList, labelTypeToRoleTypeMappingList, webConfigToLabelTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsLabelTypeBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "LABEL_TYPE";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return LabelTypeDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public LabelTypeDbm getMyDBMeta() {
        return LabelTypeDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public LabelType newMyEntity() {
        return new LabelType();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public LabelTypeCB newMyConditionBean() {
        return new LabelTypeCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * LabelTypeCB cb = new LabelTypeCB();
     * cb.query().setFoo...(value);
     * int count = labelTypeBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The selected count.
     */
    public int selectCount(LabelTypeCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(LabelTypeCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(LabelTypeCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * LabelTypeCB cb = new LabelTypeCB();
     * cb.query().setFoo...(value);
     * labelTypeBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;LabelType&gt;() {
     *     public void handle(LabelType entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of LabelType. (NotNull)
     * @param entityRowHandler The handler of entity row of LabelType. (NotNull)
     */
    public void selectCursor(LabelTypeCB cb,
            EntityRowHandler<LabelType> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, LabelType.class);
    }

    protected <ENTITY extends LabelType> void doSelectCursor(LabelTypeCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<LabelType>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * LabelTypeCB cb = new LabelTypeCB();
     * cb.query().setFoo...(value);
     * LabelType labelType = labelTypeBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (labelType != null) {
     *     ... = labelType.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelType selectEntity(LabelTypeCB cb) {
        return doSelectEntity(cb, LabelType.class);
    }

    protected <ENTITY extends LabelType> ENTITY doSelectEntity(
            final LabelTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, LabelTypeCB>() {
                    public List<ENTITY> callbackSelectList(LabelTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * LabelTypeCB cb = new LabelTypeCB();
     * cb.query().setFoo...(value);
     * LabelType labelType = labelTypeBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = labelType.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelType selectEntityWithDeletedCheck(LabelTypeCB cb) {
        return doSelectEntityWithDeletedCheck(cb, LabelType.class);
    }

    protected <ENTITY extends LabelType> ENTITY doSelectEntityWithDeletedCheck(
            final LabelTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, LabelTypeCB>() {
                    public List<ENTITY> callbackSelectList(LabelTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelType selectByPKValue(Long id) {
        return doSelectByPKValue(id, LabelType.class);
    }

    protected <ENTITY extends LabelType> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public LabelType selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, LabelType.class);
    }

    protected <ENTITY extends LabelType> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private LabelTypeCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        LabelTypeCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * LabelTypeCB cb = new LabelTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;LabelType&gt; labelTypeList = labelTypeBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (LabelType labelType : labelTypeList) {
     *     ... = labelType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<LabelType> selectList(LabelTypeCB cb) {
        return doSelectList(cb, LabelType.class);
    }

    protected <ENTITY extends LabelType> ListResultBean<ENTITY> doSelectList(
            LabelTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, LabelTypeCB>() {
                    public List<ENTITY> callbackSelectList(LabelTypeCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * LabelTypeCB cb = new LabelTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;LabelType&gt; page = labelTypeBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (LabelType labelType : page) {
     *     ... = labelType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<LabelType> selectPage(LabelTypeCB cb) {
        return doSelectPage(cb, LabelType.class);
    }

    protected <ENTITY extends LabelType> PagingResultBean<ENTITY> doSelectPage(
            LabelTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, LabelTypeCB>() {
                    public int callbackSelectCount(LabelTypeCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(LabelTypeCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * labelTypeBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(LabelTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<LabelTypeCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends LabelTypeCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            LabelType labelType,
            ConditionBeanSetupper<DataConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelType, conditionBeanSetupper);
        loadDataConfigToLabelTypeMappingList(xnewLRLs(labelType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToLabelTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * labelTypeBhv.<span style="color: #FD4747">loadDataConfigToLabelTypeMappingList</span>(labelTypeList, new ConditionBeanSetupper&lt;DataConfigToLabelTypeMappingCB&gt;() {
     *     public void setup(DataConfigToLabelTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (LabelType labelType : labelTypeList) {
     *     ... = labelType.<span style="color: #FD4747">getDataConfigToLabelTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setLabelTypeId_InScope(pkList);
     * cb.query().addOrderBy_LabelTypeId_Asc();
     * </pre>
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            ConditionBeanSetupper<DataConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelTypeList, conditionBeanSetupper);
        loadDataConfigToLabelTypeMappingList(
                labelTypeList,
                new LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            LabelType labelType,
            LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelType, loadReferrerOption);
        loadDataConfigToLabelTypeMappingList(xnewLRLs(labelType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelTypeList, loadReferrerOption);
        if (labelTypeList.isEmpty()) {
            return;
        }
        final DataConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                DataConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                labelTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<LabelType, Long, DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping>() {
                    public Long getPKVal(LabelType e) {
                        return e.getId();
                    }

                    public void setRfLs(LabelType e,
                            List<DataConfigToLabelTypeMapping> ls) {
                        e.setDataConfigToLabelTypeMappingList(ls);
                    }

                    public DataConfigToLabelTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToLabelTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setLabelTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_LabelTypeId_Asc();
                    }

                    public void spFKCol(DataConfigToLabelTypeMappingCB cb) {
                        cb.specify().columnLabelTypeId();
                    }

                    public List<DataConfigToLabelTypeMapping> selRfLs(
                            DataConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToLabelTypeMapping e) {
                        return e.getLabelTypeId();
                    }

                    public void setlcEt(DataConfigToLabelTypeMapping re,
                            LabelType le) {
                        re.setLabelType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            LabelType labelType,
            ConditionBeanSetupper<FileConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelType, conditionBeanSetupper);
        loadFileConfigToLabelTypeMappingList(xnewLRLs(labelType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToLabelTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * labelTypeBhv.<span style="color: #FD4747">loadFileConfigToLabelTypeMappingList</span>(labelTypeList, new ConditionBeanSetupper&lt;FileConfigToLabelTypeMappingCB&gt;() {
     *     public void setup(FileConfigToLabelTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (LabelType labelType : labelTypeList) {
     *     ... = labelType.<span style="color: #FD4747">getFileConfigToLabelTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setLabelTypeId_InScope(pkList);
     * cb.query().addOrderBy_LabelTypeId_Asc();
     * </pre>
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            ConditionBeanSetupper<FileConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelTypeList, conditionBeanSetupper);
        loadFileConfigToLabelTypeMappingList(
                labelTypeList,
                new LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            LabelType labelType,
            LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelType, loadReferrerOption);
        loadFileConfigToLabelTypeMappingList(xnewLRLs(labelType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelTypeList, loadReferrerOption);
        if (labelTypeList.isEmpty()) {
            return;
        }
        final FileConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                FileConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                labelTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<LabelType, Long, FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping>() {
                    public Long getPKVal(LabelType e) {
                        return e.getId();
                    }

                    public void setRfLs(LabelType e,
                            List<FileConfigToLabelTypeMapping> ls) {
                        e.setFileConfigToLabelTypeMappingList(ls);
                    }

                    public FileConfigToLabelTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FileConfigToLabelTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setLabelTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(FileConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_LabelTypeId_Asc();
                    }

                    public void spFKCol(FileConfigToLabelTypeMappingCB cb) {
                        cb.specify().columnLabelTypeId();
                    }

                    public List<FileConfigToLabelTypeMapping> selRfLs(
                            FileConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FileConfigToLabelTypeMapping e) {
                        return e.getLabelTypeId();
                    }

                    public void setlcEt(FileConfigToLabelTypeMapping re,
                            LabelType le) {
                        re.setLabelType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            LabelType labelType,
            ConditionBeanSetupper<LabelTypeToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelType, conditionBeanSetupper);
        loadLabelTypeToRoleTypeMappingList(xnewLRLs(labelType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of labelTypeToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * labelTypeBhv.<span style="color: #FD4747">loadLabelTypeToRoleTypeMappingList</span>(labelTypeList, new ConditionBeanSetupper&lt;LabelTypeToRoleTypeMappingCB&gt;() {
     *     public void setup(LabelTypeToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (LabelType labelType : labelTypeList) {
     *     ... = labelType.<span style="color: #FD4747">getLabelTypeToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setLabelTypeId_InScope(pkList);
     * cb.query().addOrderBy_LabelTypeId_Asc();
     * </pre>
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            List<LabelType> labelTypeList,
            ConditionBeanSetupper<LabelTypeToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelTypeList, conditionBeanSetupper);
        loadLabelTypeToRoleTypeMappingList(
                labelTypeList,
                new LoadReferrerOption<LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            LabelType labelType,
            LoadReferrerOption<LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(labelType, loadReferrerOption);
        loadLabelTypeToRoleTypeMappingList(xnewLRLs(labelType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            List<LabelType> labelTypeList,
            LoadReferrerOption<LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(labelTypeList, loadReferrerOption);
        if (labelTypeList.isEmpty()) {
            return;
        }
        final LabelTypeToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                LabelTypeToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                labelTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<LabelType, Long, LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping>() {
                    public Long getPKVal(LabelType e) {
                        return e.getId();
                    }

                    public void setRfLs(LabelType e,
                            List<LabelTypeToRoleTypeMapping> ls) {
                        e.setLabelTypeToRoleTypeMappingList(ls);
                    }

                    public LabelTypeToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(LabelTypeToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setLabelTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(LabelTypeToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_LabelTypeId_Asc();
                    }

                    public void spFKCol(LabelTypeToRoleTypeMappingCB cb) {
                        cb.specify().columnLabelTypeId();
                    }

                    public List<LabelTypeToRoleTypeMapping> selRfLs(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(LabelTypeToRoleTypeMapping e) {
                        return e.getLabelTypeId();
                    }

                    public void setlcEt(LabelTypeToRoleTypeMapping re,
                            LabelType le) {
                        re.setLabelType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            LabelType labelType,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelType, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(labelType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToLabelTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * labelTypeBhv.<span style="color: #FD4747">loadWebConfigToLabelTypeMappingList</span>(labelTypeList, new ConditionBeanSetupper&lt;WebConfigToLabelTypeMappingCB&gt;() {
     *     public void setup(WebConfigToLabelTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (LabelType labelType : labelTypeList) {
     *     ... = labelType.<span style="color: #FD4747">getWebConfigToLabelTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setLabelTypeId_InScope(pkList);
     * cb.query().addOrderBy_LabelTypeId_Asc();
     * </pre>
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(labelTypeList, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(
                labelTypeList,
                new LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param labelType The entity of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            LabelType labelType,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelType, loadReferrerOption);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(labelType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param labelTypeList The entity list of labelType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<LabelType> labelTypeList,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(labelTypeList, loadReferrerOption);
        if (labelTypeList.isEmpty()) {
            return;
        }
        final WebConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                labelTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<LabelType, Long, WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>() {
                    public Long getPKVal(LabelType e) {
                        return e.getId();
                    }

                    public void setRfLs(LabelType e,
                            List<WebConfigToLabelTypeMapping> ls) {
                        e.setWebConfigToLabelTypeMappingList(ls);
                    }

                    public WebConfigToLabelTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToLabelTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setLabelTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_LabelTypeId_Asc();
                    }

                    public void spFKCol(WebConfigToLabelTypeMappingCB cb) {
                        cb.specify().columnLabelTypeId();
                    }

                    public List<WebConfigToLabelTypeMapping> selRfLs(
                            WebConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToLabelTypeMapping e) {
                        return e.getLabelTypeId();
                    }

                    public void setlcEt(WebConfigToLabelTypeMapping re,
                            LabelType le) {
                        re.setLabelType(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * LabelType labelType = new LabelType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * labelType.setFoo...(value);
     * labelType.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//labelType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//labelType.set...;</span>
     * labelTypeBhv.<span style="color: #FD4747">insert</span>(labelType);
     * ... = labelType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param labelType The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(LabelType labelType) {
        doInsert(labelType, null);
    }

    protected void doInsert(LabelType labelType,
            InsertOption<LabelTypeCB> option) {
        assertObjectNotNull("labelType", labelType);
        prepareInsertOption(option);
        delegateInsert(labelType, option);
    }

    protected void prepareInsertOption(InsertOption<LabelTypeCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * LabelType labelType = new LabelType();
     * labelType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * labelType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//labelType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//labelType.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * labelType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     labelTypeBhv.<span style="color: #FD4747">update</span>(labelType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param labelType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final LabelType labelType) {
        doUpdate(labelType, null);
    }

    protected void doUpdate(LabelType labelType,
            final UpdateOption<LabelTypeCB> option) {
        assertObjectNotNull("labelType", labelType);
        prepareUpdateOption(option);
        helpUpdateInternally(labelType,
                new InternalUpdateCallback<LabelType>() {
                    public int callbackDelegateUpdate(LabelType entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(UpdateOption<LabelTypeCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected LabelTypeCB createCBForVaryingUpdate() {
        LabelTypeCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected LabelTypeCB createCBForSpecifiedUpdate() {
        LabelTypeCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * LabelType labelType = new LabelType();
     * labelType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * labelType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//labelType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//labelType.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelType.setVersionNo(value);</span>
     * labelTypeBhv.<span style="color: #FD4747">updateNonstrict</span>(labelType);
     * </pre>
     * @param labelType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final LabelType labelType) {
        doUpdateNonstrict(labelType, null);
    }

    protected void doUpdateNonstrict(LabelType labelType,
            final UpdateOption<LabelTypeCB> option) {
        assertObjectNotNull("labelType", labelType);
        prepareUpdateOption(option);
        helpUpdateNonstrictInternally(labelType,
                new InternalUpdateNonstrictCallback<LabelType>() {
                    public int callbackDelegateUpdateNonstrict(LabelType entity) {
                        return delegateUpdateNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            updateNonstrict(downcast(entity));
        } else {
            varyingUpdateNonstrict(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param labelType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(LabelType labelType) {
        doInesrtOrUpdate(labelType, null, null);
    }

    protected void doInesrtOrUpdate(LabelType labelType,
            final InsertOption<LabelTypeCB> insertOption,
            final UpdateOption<LabelTypeCB> updateOption) {
        helpInsertOrUpdateInternally(labelType,
                new InternalInsertOrUpdateCallback<LabelType, LabelTypeCB>() {
                    public void callbackInsert(LabelType entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(LabelType entity) {
                        doUpdate(entity, updateOption);
                    }

                    public LabelTypeCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(LabelTypeCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param labelType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(LabelType labelType) {
        doInesrtOrUpdateNonstrict(labelType, null, null);
    }

    protected void doInesrtOrUpdateNonstrict(LabelType labelType,
            final InsertOption<LabelTypeCB> insertOption,
            final UpdateOption<LabelTypeCB> updateOption) {
        helpInsertOrUpdateInternally(labelType,
                new InternalInsertOrUpdateNonstrictCallback<LabelType>() {
                    public void callbackInsert(LabelType entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdateNonstrict(LabelType entity) {
                        doUpdateNonstrict(entity, updateOption);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdateNonstrict(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdateNonstrict(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * LabelType labelType = new LabelType();
     * labelType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * labelType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     labelTypeBhv.<span style="color: #FD4747">delete</span>(labelType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param labelType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(LabelType labelType) {
        doDelete(labelType, null);
    }

    protected void doDelete(LabelType labelType,
            final DeleteOption<LabelTypeCB> option) {
        assertObjectNotNull("labelType", labelType);
        prepareDeleteOption(option);
        helpDeleteInternally(labelType,
                new InternalDeleteCallback<LabelType>() {
                    public int callbackDelegateDelete(LabelType entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(DeleteOption<LabelTypeCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * LabelType labelType = new LabelType();
     * labelType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelType.setVersionNo(value);</span>
     * labelTypeBhv.<span style="color: #FD4747">deleteNonstrict</span>(labelType);
     * </pre>
     * @param labelType The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(LabelType labelType) {
        doDeleteNonstrict(labelType, null);
    }

    protected void doDeleteNonstrict(LabelType labelType,
            final DeleteOption<LabelTypeCB> option) {
        assertObjectNotNull("labelType", labelType);
        prepareDeleteOption(option);
        helpDeleteNonstrictInternally(labelType,
                new InternalDeleteNonstrictCallback<LabelType>() {
                    public int callbackDelegateDeleteNonstrict(LabelType entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * LabelType labelType = new LabelType();
     * labelType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelType.setVersionNo(value);</span>
     * labelTypeBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(labelType);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param labelType The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(LabelType labelType) {
        doDeleteNonstrictIgnoreDeleted(labelType, null);
    }

    protected void doDeleteNonstrictIgnoreDeleted(LabelType labelType,
            final DeleteOption<LabelTypeCB> option) {
        assertObjectNotNull("labelType", labelType);
        prepareDeleteOption(option);
        helpDeleteNonstrictIgnoreDeletedInternally(labelType,
                new InternalDeleteNonstrictIgnoreDeletedCallback<LabelType>() {
                    public int callbackDelegateDeleteNonstrict(LabelType entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            deleteNonstrict(downcast(entity));
        } else {
            varyingDeleteNonstrict(downcast(entity), (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<LabelType> labelTypeList) {
        return doBatchInsert(labelTypeList, null);
    }

    protected int[] doBatchInsert(List<LabelType> labelTypeList,
            InsertOption<LabelTypeCB> option) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        prepareInsertOption(option);
        return delegateBatchInsert(labelTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<LabelType> labelTypeList) {
        return doBatchUpdate(labelTypeList, null);
    }

    protected int[] doBatchUpdate(List<LabelType> labelTypeList,
            UpdateOption<LabelTypeCB> option) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(labelTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param labelTypeList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<LabelType> labelTypeList,
            SpecifyQuery<LabelTypeCB> updateColumnSpec) {
        return doBatchUpdate(labelTypeList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<LabelType> labelTypeList) {
        return doBatchUpdateNonstrict(labelTypeList, null);
    }

    protected int[] doBatchUpdateNonstrict(List<LabelType> labelTypeList,
            UpdateOption<LabelTypeCB> option) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        prepareUpdateOption(option);
        return delegateBatchUpdateNonstrict(labelTypeList, option);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param labelTypeList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<LabelType> labelTypeList,
            SpecifyQuery<LabelTypeCB> updateColumnSpec) {
        return doBatchUpdateNonstrict(labelTypeList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdateNonstrict((List) ls);
        } else {
            return varyingBatchUpdateNonstrict((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<LabelType> labelTypeList) {
        return doBatchDelete(labelTypeList, null);
    }

    protected int[] doBatchDelete(List<LabelType> labelTypeList,
            DeleteOption<LabelTypeCB> option) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        prepareDeleteOption(option);
        return delegateBatchDelete(labelTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param labelTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<LabelType> labelTypeList) {
        return doBatchDeleteNonstrict(labelTypeList, null);
    }

    protected int[] doBatchDeleteNonstrict(List<LabelType> labelTypeList,
            DeleteOption<LabelTypeCB> option) {
        assertObjectNotNull("labelTypeList", labelTypeList);
        prepareDeleteOption(option);
        return delegateBatchDeleteNonstrict(labelTypeList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDeleteNonstrict((List) ls);
        } else {
            return varyingBatchDeleteNonstrict((List) ls, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * labelTypeBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;labelType, LabelTypeCB&gt;() {
     *     public ConditionBean setup(labelType entity, LabelTypeCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(QueryInsertSetupper<LabelType, LabelTypeCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<LabelType, LabelTypeCB> setupper,
            InsertOption<LabelTypeCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        LabelType entity = new LabelType();
        LabelTypeCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected LabelTypeCB createCBForQueryInsert() {
        LabelTypeCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * LabelType labelType = new LabelType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//labelType.setPK...(value);</span>
     * labelType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//labelType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//labelType.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelType.setVersionNo(value);</span>
     * LabelTypeCB cb = new LabelTypeCB();
     * cb.query().setFoo...(value);
     * labelTypeBhv.<span style="color: #FD4747">queryUpdate</span>(labelType, cb);
     * </pre>
     * @param labelType The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(LabelType labelType, LabelTypeCB cb) {
        return doQueryUpdate(labelType, cb, null);
    }

    protected int doQueryUpdate(LabelType labelType, LabelTypeCB cb,
            UpdateOption<LabelTypeCB> option) {
        assertObjectNotNull("labelType", labelType);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(labelType, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (LabelTypeCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity), (LabelTypeCB) cb,
                    (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * LabelTypeCB cb = new LabelTypeCB();
     * cb.query().setFoo...(value);
     * labelTypeBhv.<span style="color: #FD4747">queryDelete</span>(labelType, cb);
     * </pre>
     * @param cb The condition-bean of LabelType. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(LabelTypeCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(LabelTypeCB cb, DeleteOption<LabelTypeCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((LabelTypeCB) cb);
        } else {
            return varyingQueryDelete((LabelTypeCB) cb, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * LabelType labelType = new LabelType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * labelType.setFoo...(value);
     * labelType.setBar...(value);
     * InsertOption<LabelTypeCB> option = new InsertOption<LabelTypeCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * labelTypeBhv.<span style="color: #FD4747">varyingInsert</span>(labelType, option);
     * ... = labelType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param labelType The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(LabelType labelType,
            InsertOption<LabelTypeCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(labelType, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * LabelType labelType = new LabelType();
     * labelType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * labelType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * labelType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;LabelTypeCB&gt; option = new UpdateOption&lt;LabelTypeCB&gt;();
     *     option.self(new SpecifyQuery&lt;LabelTypeCB&gt;() {
     *         public void specify(LabelTypeCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     labelTypeBhv.<span style="color: #FD4747">varyingUpdate</span>(labelType, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param labelType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(LabelType labelType,
            UpdateOption<LabelTypeCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(labelType, option);
    }

    /**
     * Update the entity with varying requests non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as updateNonstrict(entity).
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * LabelType labelType = new LabelType();
     * labelType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * labelType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelType.setVersionNo(value);</span>
     * UpdateOption&lt;LabelTypeCB&gt; option = new UpdateOption&lt;LabelTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;LabelTypeCB&gt;() {
     *     public void specify(LabelTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * labelTypeBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(labelType, option);
     * </pre>
     * @param labelType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(LabelType labelType,
            UpdateOption<LabelTypeCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdateNonstrict(labelType, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param labelType The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(LabelType labelType,
            InsertOption<LabelTypeCB> insertOption,
            UpdateOption<LabelTypeCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(labelType, insertOption, updateOption);
    }

    /**
     * Insert or update the entity with varying requests non-strictly. {NonExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdateNonstrict(entity).
     * @param labelType The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdateNonstrict(LabelType labelType,
            InsertOption<LabelTypeCB> insertOption,
            UpdateOption<LabelTypeCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdateNonstrict(labelType, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param labelType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(LabelType labelType,
            DeleteOption<LabelTypeCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(labelType, option);
    }

    /**
     * Delete the entity with varying requests non-strictly. {UpdateCountZeroException, NonExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as deleteNonstrict(entity).
     * @param labelType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDeleteNonstrict(LabelType labelType,
            DeleteOption<LabelTypeCB> option) {
        assertDeleteOptionNotNull(option);
        doDeleteNonstrict(labelType, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param labelTypeList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(List<LabelType> labelTypeList,
            InsertOption<LabelTypeCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(labelTypeList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param labelTypeList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(List<LabelType> labelTypeList,
            UpdateOption<LabelTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(labelTypeList, option);
    }

    /**
     * Batch-update the list with varying requests non-strictly. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param labelTypeList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdateNonstrict(List<LabelType> labelTypeList,
            UpdateOption<LabelTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdateNonstrict(labelTypeList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param labelTypeList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(List<LabelType> labelTypeList,
            DeleteOption<LabelTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(labelTypeList, option);
    }

    /**
     * Batch-delete the list with varying requests non-strictly. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDeleteNonstrict(entityList).
     * @param labelTypeList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDeleteNonstrict(List<LabelType> labelTypeList,
            DeleteOption<LabelTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDeleteNonstrict(labelTypeList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<LabelType, LabelTypeCB> setupper,
            InsertOption<LabelTypeCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * LabelType labelType = new LabelType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//labelType.setPK...(value);</span>
     * labelType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//labelType.setVersionNo(value);</span>
     * LabelTypeCB cb = new LabelTypeCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;LabelTypeCB&gt; option = new UpdateOption&lt;LabelTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;LabelTypeCB&gt;() {
     *     public void specify(LabelTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * labelTypeBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(labelType, cb, option);
     * </pre>
     * @param labelType The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of LabelType. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(LabelType labelType, LabelTypeCB cb,
            UpdateOption<LabelTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(labelType, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of LabelType. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(LabelTypeCB cb,
            DeleteOption<LabelTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<LabelTypeBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(LabelTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(LabelTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends LabelType> void delegateSelectCursor(
            LabelTypeCB cb, EntityRowHandler<ENTITY> erh, Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends LabelType> List<ENTITY> delegateSelectList(
            LabelTypeCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(LabelType e, InsertOption<LabelTypeCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(LabelType e, UpdateOption<LabelTypeCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateEntityCommand(e, op));
    }

    protected int delegateUpdateNonstrict(LabelType e,
            UpdateOption<LabelTypeCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(LabelType e, DeleteOption<LabelTypeCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteEntityCommand(e, op));
    }

    protected int delegateDeleteNonstrict(LabelType e,
            DeleteOption<LabelTypeCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<LabelType> ls,
            InsertOption<LabelTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<LabelType> ls,
            UpdateOption<LabelTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchUpdateNonstrict(List<LabelType> ls,
            UpdateOption<LabelTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<LabelType> ls,
            DeleteOption<LabelTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchDeleteNonstrict(List<LabelType> ls,
            DeleteOption<LabelTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(LabelType e, LabelTypeCB inCB,
            ConditionBean resCB, InsertOption<LabelTypeCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(LabelType e, LabelTypeCB cb,
            UpdateOption<LabelTypeCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(LabelTypeCB cb,
            DeleteOption<LabelTypeCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected LabelType downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, LabelType.class);
    }

    protected LabelTypeCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, LabelTypeCB.class);
    }
}
